/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.jeeintegration;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.util.Modules;
import io.joynr.ProvidedBy;
import io.joynr.capabilities.ParticipantIdKeyUtil;
import io.joynr.exceptions.JoynrIllegalStateException;
import io.joynr.jeeintegration.BeanCallingProxy;
import io.joynr.jeeintegration.JeeJoynrIntegrationModule;
import io.joynr.jeeintegration.JoynrRuntimeFactory;
import io.joynr.jeeintegration.api.JoynrLocalDomain;
import io.joynr.jeeintegration.api.JoynrMqttClientIdProvider;
import io.joynr.jeeintegration.api.JoynrProperties;
import io.joynr.jeeintegration.api.JoynrRawMessagingPreprocessor;
import io.joynr.messaging.JoynrMessageProcessor;
import io.joynr.messaging.NoOpRawMessagingPreprocessor;
import io.joynr.messaging.RawMessagingPreprocessor;
import io.joynr.messaging.mqtt.MqttClientIdProvider;
import io.joynr.provider.JoynrInterface;
import io.joynr.provider.ProviderAnnotations;
import io.joynr.runtime.CCInProcessRuntimeModule;
import io.joynr.runtime.JoynrInjectorFactory;
import io.joynr.runtime.JoynrRuntime;
import io.joynr.statusmetrics.JoynrStatusMetrics;
import io.joynr.statusmetrics.JoynrStatusMetricsReceiver;
import io.joynr.util.ObjectMapper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;
import javax.annotation.Resource;
import javax.ejb.DependsOn;
import javax.ejb.Singleton;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Inject;
import joynr.infrastructure.DacTypes.MasterAccessControlEntry;
import joynr.infrastructure.DacTypes.Permission;
import joynr.infrastructure.DacTypes.TrustLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DependsOn(value={"JeeJoynrStatusMetricsAggregator"})
@Singleton
public class DefaultJoynrRuntimeFactory
implements JoynrRuntimeFactory {
    private static final Logger logger = LoggerFactory.getLogger(DefaultJoynrRuntimeFactory.class);
    private static final String MQTT = "mqtt";
    private Properties joynrProperties;
    private final String joynrLocalDomain;
    private BeanManager beanManager;
    private JoynrStatusMetricsReceiver joynrStatusMetrics;
    @Resource(name="concurrent/joynrMessagingScheduledExecutor")
    private ScheduledExecutorService scheduledExecutorService;
    private Injector fInjector = null;
    private RawMessagingPreprocessor rawMessagePreprocessor;
    private MqttClientIdProvider mqttClientIdProvider;

    /*
     * Enabled aggressive block sorting
     */
    @Inject
    public DefaultJoynrRuntimeFactory(@JoynrProperties Instance<Properties> joynrProperties, @JoynrLocalDomain Instance<String> joynrLocalDomain, @JoynrRawMessagingPreprocessor Instance<RawMessagingPreprocessor> rawMessagePreprocessor, @JoynrMqttClientIdProvider Instance<MqttClientIdProvider> mqttClientIdProvider, BeanManager beanManager, JoynrStatusMetricsReceiver joynrStatusMetrics) {
        Properties configuredProperties;
        if (joynrLocalDomain.isUnsatisfied()) {
            String message = "No local domain name specified. Please provide a value for the local domain via @JoynrLocalDomain in your configuration EJB.";
            logger.error(message);
            throw new JoynrIllegalStateException(message);
        }
        if (joynrLocalDomain.isAmbiguous()) {
            String message = "Multiple local domain names specified. Please provide only one configuration EJB containing a value for the local domain via @JoynrLocalDomain.";
            logger.error(message);
            throw new JoynrIllegalStateException(message);
        }
        this.joynrLocalDomain = (String)joynrLocalDomain.get();
        if (this.joynrLocalDomain == null || this.joynrLocalDomain.isEmpty()) {
            String message = "Local domain name is NULL or EMPTY. Please provide a value for the local domain via @JoynrLocalDomain in your configuration EJB.";
            logger.error(message);
            throw new JoynrIllegalStateException(message);
        }
        if (!rawMessagePreprocessor.isUnsatisfied()) {
            if (rawMessagePreprocessor.isAmbiguous()) {
                String message = "Only one RawMessagePreprocessor may be provided.";
                logger.error(message);
                throw new JoynrIllegalStateException(message);
            }
            this.rawMessagePreprocessor = (RawMessagingPreprocessor)rawMessagePreprocessor.get();
        } else {
            this.rawMessagePreprocessor = new NoOpRawMessagingPreprocessor();
        }
        if (!mqttClientIdProvider.isUnsatisfied()) {
            if (mqttClientIdProvider.isAmbiguous()) {
                String message = "Only one MqttClientIdProvider may be provided";
                logger.error(message);
                throw new JoynrIllegalStateException(message);
            }
            this.mqttClientIdProvider = (MqttClientIdProvider)mqttClientIdProvider.get();
        } else {
            this.mqttClientIdProvider = null;
        }
        if (!joynrProperties.isUnsatisfied()) {
            if (joynrProperties.isAmbiguous()) {
                String message = "Multiple joynrProperties specified. Please provide only one configuration EJB containing a value for the joynrProperties via @JoynrProperties.";
                logger.error(message);
                throw new JoynrIllegalStateException(message);
            }
            configuredProperties = (Properties)joynrProperties.get();
            logger.info("Got custom joynr properties: {}", (Object)configuredProperties);
        } else {
            logger.info("No custom joynr properties provided. Will use default properties.");
            configuredProperties = new Properties();
        }
        this.joynrProperties = this.prepareJoynrProperties(configuredProperties);
        this.beanManager = beanManager;
        this.joynrStatusMetrics = joynrStatusMetrics;
    }

    @Override
    public JoynrRuntime create(Set<Class<?>> providerInterfaceClasses) {
        logger.info("Creating clusterable participant IDs for discovered providers.");
        this.createClusterableParticipantIds(providerInterfaceClasses);
        logger.info("Provisioning access control for {}", providerInterfaceClasses);
        this.provisionAccessControl(this.joynrProperties, this.joynrLocalDomain, this.getProviderInterfaceNames(providerInterfaceClasses));
        logger.info(String.format("Creating application with joynr properties:%n%s", this.joynrProperties));
        JoynrRuntime runtime = (JoynrRuntime)this.getInjector().getInstance(JoynrRuntime.class);
        logger.info("Created runtime: {}", (Object)runtime);
        return runtime;
    }

    private void createClusterableParticipantIds(Set<Class<?>> providerInterfaceClasses) {
        for (Class<?> joynrProviderClass : providerInterfaceClasses) {
            String participantIdKey = ParticipantIdKeyUtil.getProviderParticipantIdKey((String)this.getLocalDomain(), joynrProviderClass);
            if (this.joynrProperties.containsKey(participantIdKey)) continue;
            this.joynrProperties.put(participantIdKey, this.createClusterableParticipantId(joynrProviderClass));
        }
    }

    private String createClusterableParticipantId(Class<?> joynrProviderClass) {
        String key = this.getLocalDomain() + "." + this.joynrProperties.getProperty("joynr.messaging.channelid") + "." + this.getInterfaceName(joynrProviderClass);
        return key.replace("/", ".");
    }

    @Override
    public Injector getInjector() {
        if (this.fInjector == null) {
            Module jeeModule = Modules.override((Module[])new Module[]{new CCInProcessRuntimeModule()}).with(new Module[]{new JeeJoynrIntegrationModule(this.scheduledExecutorService)});
            Module finalModule = Modules.override((Module[])new Module[]{jeeModule}).with(new Module[]{new AbstractModule(){

                protected void configure() {
                    this.bind(RawMessagingPreprocessor.class).toInstance((Object)DefaultJoynrRuntimeFactory.this.rawMessagePreprocessor);
                    if (DefaultJoynrRuntimeFactory.this.mqttClientIdProvider != null) {
                        this.bind(MqttClientIdProvider.class).toInstance((Object)DefaultJoynrRuntimeFactory.this.mqttClientIdProvider);
                    }
                    this.bind(JoynrStatusMetrics.class).toInstance((Object)DefaultJoynrRuntimeFactory.this.joynrStatusMetrics);
                    this.bind(JoynrStatusMetricsReceiver.class).toInstance((Object)DefaultJoynrRuntimeFactory.this.joynrStatusMetrics);
                }
            }});
            this.fInjector = new JoynrInjectorFactory(this.joynrProperties, new Module[]{this.getMessageProcessorsModule(), finalModule}).getInjector();
        }
        return this.fInjector;
    }

    private AbstractModule getMessageProcessorsModule() {
        return this.getModuleForBeansOfType(JoynrMessageProcessor.class, () -> new TypeLiteral<JoynrMessageProcessor>(){});
    }

    private <T> AbstractModule getModuleForBeansOfType(final Class<T> beanType, final Supplier<TypeLiteral<T>> typeLiteralSupplier) {
        final Set beans = this.beanManager.getBeans(beanType, new Annotation[]{new AnnotationLiteral<Any>(){
            private static final long serialVersionUID = 1L;
        }});
        return new AbstractModule(){

            protected void configure() {
                Multibinder beanMultibinder = Multibinder.newSetBinder((Binder)this.binder(), (TypeLiteral)((TypeLiteral)typeLiteralSupplier.get()));
                for (Bean bean : beans) {
                    beanMultibinder.addBinding().toInstance(Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), new Class[]{beanType}, new BeanCallingProxy(bean, DefaultJoynrRuntimeFactory.this.beanManager)));
                }
            }
        };
    }

    private Properties prepareJoynrProperties(Properties configuredProperties) {
        Properties defaultJoynrProperties = new Properties();
        defaultJoynrProperties.setProperty("joynr.domain.local", this.joynrLocalDomain);
        defaultJoynrProperties.putAll((Map<?, ?>)configuredProperties);
        return defaultJoynrProperties;
    }

    private String[] getProviderInterfaceNames(Set<Class<?>> providerInterfaceClasses) {
        HashSet<String> providerInterfaceNames = new HashSet<String>();
        for (Class<?> providerInterfaceClass : providerInterfaceClasses) {
            providerInterfaceNames.add(this.getInterfaceName(providerInterfaceClass));
        }
        return providerInterfaceNames.toArray(new String[providerInterfaceNames.size()]);
    }

    private String getInterfaceName(Class<?> providerInterfaceClass) {
        try {
            ProvidedBy providedBy = providerInterfaceClass.getAnnotation(ProvidedBy.class);
            JoynrInterface joynrInterface = providedBy.value().getAnnotation(JoynrInterface.class);
            return joynrInterface.name() + ".v" + ProviderAnnotations.getMajorVersion((Class)providedBy.value());
        }
        catch (IllegalArgumentException | SecurityException e) {
            logger.debug("error getting interface details", (Throwable)e);
            return providerInterfaceClass.getSimpleName();
        }
    }

    private void provisionAccessControl(Properties properties, String domain, String[] interfaceNames) {
        boolean enableAccessControl = Boolean.valueOf(properties.getProperty("joynr.accesscontrol.enable", Boolean.FALSE.toString()));
        if (!enableAccessControl) {
            return;
        }
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.enableDefaultTypingAsProperty(ObjectMapper.DefaultTyping.JAVA_LANG_OBJECT, "_typeName");
        ArrayList<MasterAccessControlEntry> allEntries = new ArrayList<MasterAccessControlEntry>();
        for (String interfaceName : interfaceNames) {
            MasterAccessControlEntry newMasterAccessControlEntry = new MasterAccessControlEntry("*", domain, interfaceName, TrustLevel.LOW, new TrustLevel[]{TrustLevel.LOW}, TrustLevel.LOW, new TrustLevel[]{TrustLevel.LOW}, "*", Permission.YES, new Permission[]{Permission.YES});
            allEntries.add(newMasterAccessControlEntry);
        }
        MasterAccessControlEntry[] provisionedAccessControlEntries = allEntries.toArray(new MasterAccessControlEntry[allEntries.size()]);
        try {
            String provisionedAccessControlEntriesAsJson = objectMapper.writeValueAsString((Object)provisionedAccessControlEntries);
            properties.setProperty("joynr.accesscontrol.provisioned.masteraces", provisionedAccessControlEntriesAsJson);
        }
        catch (JsonProcessingException e) {
            logger.error("Error parsing JSON.", (Throwable)e);
        }
    }

    @Override
    public String getLocalDomain() {
        return this.joynrLocalDomain;
    }

    public RawMessagingPreprocessor getRawMessagePreprocessor() {
        return this.rawMessagePreprocessor;
    }

    public MqttClientIdProvider getMqttClientIdProvider() {
        return this.mqttClientIdProvider;
    }
}

