/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.jeeintegration.messaging;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.OptionalBinder;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import io.joynr.jeeintegration.messaging.JeeMqttMessagingSkeletonProvider;
import io.joynr.messaging.AbstractMiddlewareMessagingStubFactory;
import io.joynr.messaging.IMessagingSkeletonFactory;
import io.joynr.messaging.IMessagingStub;
import io.joynr.messaging.mqtt.DefaultMqttClientIdProvider;
import io.joynr.messaging.mqtt.DefaultMqttTopicPrefixProvider;
import io.joynr.messaging.mqtt.MqttCiphersuiteListFactory;
import io.joynr.messaging.mqtt.MqttClientFactory;
import io.joynr.messaging.mqtt.MqttClientIdProvider;
import io.joynr.messaging.mqtt.MqttGlobalAddressFactory;
import io.joynr.messaging.mqtt.MqttMessagingStubFactory;
import io.joynr.messaging.mqtt.MqttMulticastAddressCalculator;
import io.joynr.messaging.mqtt.MqttMultipleBackendPropertyProvider;
import io.joynr.messaging.mqtt.MqttReplyToAddressFactory;
import io.joynr.messaging.mqtt.MqttTopicPrefixProvider;
import io.joynr.messaging.mqtt.hivemq.client.HivemqMqttClientFactory;
import io.joynr.messaging.mqtt.hivemq.client.HivemqMqttClientTrustManagerFactory;
import io.joynr.messaging.mqtt.hivemq.client.IHivemqMqttClientTrustManagerFactory;
import io.joynr.messaging.routing.GlobalAddressFactory;
import io.joynr.messaging.routing.MulticastAddressCalculator;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import joynr.system.RoutingTypes.Address;
import joynr.system.RoutingTypes.MqttAddress;

public class JeeMqttMessageSendingModule
extends AbstractModule {
    private MapBinder<Class<? extends Address>, AbstractMiddlewareMessagingStubFactory<? extends IMessagingStub, ? extends Address>> messagingStubFactory;
    private MapBinder<Class<? extends Address>, IMessagingSkeletonFactory> messagingSkeletonFactory;

    public JeeMqttMessageSendingModule(MapBinder<Class<? extends Address>, IMessagingSkeletonFactory> messagingSkeletonFactory, MapBinder<Class<? extends Address>, AbstractMiddlewareMessagingStubFactory<? extends IMessagingStub, ? extends Address>> messagingStubFactory) {
        this.messagingSkeletonFactory = messagingSkeletonFactory;
        this.messagingStubFactory = messagingStubFactory;
    }

    @Provides
    @Named(value="property_mqtt_global_address")
    public MqttAddress provideMqttOwnAddress(MqttGlobalAddressFactory globalAddressFactory) {
        return globalAddressFactory.create();
    }

    @Provides
    @Named(value="property_mqtt_reply_to_address")
    public MqttAddress provideMqttOwnAddress(MqttReplyToAddressFactory replyToAddressFactory) {
        return replyToAddressFactory.create();
    }

    @Provides
    @Named(value="joynr.internal.messaging.mqtt.gbidtobrokerurimap")
    public HashMap<String, String> provideGbidToBrokerUriMap(MqttMultipleBackendPropertyProvider mqttMultipleBackendPropertyProvider) {
        return mqttMultipleBackendPropertyProvider.provideGbidToBrokerUriMap();
    }

    @Provides
    @Named(value="joynr.internal.messaging.mqtt.brokeruriarray")
    public String[] provideMqttBrokerUriArray(MqttMultipleBackendPropertyProvider mqttMultipleBackendPropertyProvider) {
        return mqttMultipleBackendPropertyProvider.provideBrokerUris();
    }

    @Provides
    @Named(value="joynr.internal.messaging.mqtt.gbidtokeepalivetimersecmap")
    public HashMap<String, Integer> provideGbidTpKeepAliveTimerSecMap(MqttMultipleBackendPropertyProvider mqttMultipleBackendPropertyProvider) {
        return mqttMultipleBackendPropertyProvider.provideGbidToKeepAliveTimerSecMap();
    }

    @Provides
    @Named(value="joynr.internal.messaging.mqtt.gbidtoconnectiontimeoutsecmap")
    public HashMap<String, Integer> provideGbidToConnectionTimeoutSecMap(MqttMultipleBackendPropertyProvider mqttMultipleBackendPropertyProvider) {
        return mqttMultipleBackendPropertyProvider.provideGbidToConnectionTimeoutSecMap();
    }

    @Provides
    @Named(value="joynr.internal.messaging.mqtt.ssl.ciphersuiteList")
    public List<String> provideMqttInternalCipherList(MqttCiphersuiteListFactory internalCipherListFactory) {
        return internalCipherListFactory.create();
    }

    @Provides
    @Named(value="joynr.messaging.mqtt.separatereplyreceiver")
    public boolean provideSeparateReplyReceiverSetting(@Named(value="joynr.messaging.mqtt.enable.sharedsubscriptions") boolean enableSharedSubscriptions) {
        return enableSharedSubscriptions;
    }

    protected void configure() {
        this.messagingStubFactory.addBinding(MqttAddress.class).to(MqttMessagingStubFactory.class);
        this.messagingSkeletonFactory.addBinding(MqttAddress.class).toProvider(JeeMqttMessagingSkeletonProvider.class);
        Multibinder globalAddresses = Multibinder.newSetBinder((Binder)this.binder(), (TypeLiteral)new TypeLiteral<GlobalAddressFactory<? extends Address>>(){}, (Annotation)Names.named((String)"global_address_factories"));
        globalAddresses.addBinding().to(MqttGlobalAddressFactory.class);
        Multibinder replyToAddresses = Multibinder.newSetBinder((Binder)this.binder(), (TypeLiteral)new TypeLiteral<GlobalAddressFactory<? extends Address>>(){}, (Annotation)Names.named((String)"reply_to_address_factories"));
        replyToAddresses.addBinding().to(MqttReplyToAddressFactory.class);
        this.bind(MqttClientFactory.class).to(HivemqMqttClientFactory.class);
        this.bind(IHivemqMqttClientTrustManagerFactory.class).to(HivemqMqttClientTrustManagerFactory.class);
        this.bind(MqttTopicPrefixProvider.class).to(DefaultMqttTopicPrefixProvider.class);
        this.bind(MqttClientIdProvider.class).to(DefaultMqttClientIdProvider.class);
        OptionalBinder.newOptionalBinder((Binder)this.binder(), MulticastAddressCalculator.class).setBinding().to(MqttMulticastAddressCalculator.class);
    }
}

