/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.jeeintegration;

import io.joynr.ProvidedBy;
import io.joynr.jeeintegration.api.ServiceProvider;
import io.joynr.util.AnnotationUtil;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceProviderDiscovery {
    private static final Logger logger = LoggerFactory.getLogger(ServiceProviderDiscovery.class);
    private final BeanManager beanManager;

    @Inject
    public ServiceProviderDiscovery(BeanManager beanManager) {
        this.beanManager = beanManager;
    }

    public Set<Bean<?>> findServiceProviderBeans() {
        HashSet result = new HashSet();
        for (Bean bean : this.beanManager.getBeans(Object.class, new Annotation[]{new AnnotationLiteral<Any>(){}})) {
            ServiceProvider serviceProvider = bean.getBeanClass().getAnnotation(ServiceProvider.class);
            if (serviceProvider != null) {
                ProvidedBy providedBy = this.getProvidedByAnnotation(serviceProvider.serviceInterface());
                this.verifyProvidedBy(providedBy, serviceProvider.serviceInterface(), bean);
                result.add(bean);
                if (!logger.isTraceEnabled()) continue;
                logger.trace(String.format("Bean %s is a service provider. Adding to result.", bean));
                continue;
            }
            if (!logger.isTraceEnabled()) continue;
            logger.trace(String.format("Ignoring bean: %s", bean));
        }
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Found the following service provider beans:%n%s", result));
        }
        return result;
    }

    private void verifyProvidedBy(ProvidedBy providedBy, Class<?> serviceInterface, Bean<?> bean) {
        if (providedBy == null) {
            throw new IllegalArgumentException(String.format("The bean %s is annotated with ServiceProvider, but the specified service interface %s is not annotated with @ProvidedBy.%nMake sure that you implement a *Sync interface and that you specify that same *Sync interface as the serviceInterface.%nNote: Are you using an outdated version of the generator?%nIn older versions of the generator, you have to set the now deprecated 'jee' parameter to 'true' in order to correctly generate the @ProvidedBy annotation on the Sync interfaces. This annoation is now generated automatically.", bean, serviceInterface));
        }
    }

    public Class<?> getProviderInterfaceFor(Class<?> businessInterface) {
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("Looking for provider interface for business interface %s", businessInterface));
        }
        assert (businessInterface != null) : "businessInterface must not be null";
        ProvidedBy providedBy = this.getProvidedByAnnotation(businessInterface);
        if (providedBy == null) {
            throw new IllegalArgumentException(String.format("Unable to find suitable joynr provider for interface %s", businessInterface));
        }
        Class result = providedBy.value();
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("Returning: %s", result));
        }
        return result;
    }

    private ProvidedBy getProvidedByAnnotation(Class<?> businessInterface) {
        return (ProvidedBy)AnnotationUtil.getAnnotation(businessInterface, ProvidedBy.class);
    }
}

