/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.jeeintegration;

import io.joynr.StatelessAsync;
import io.joynr.arbitration.DiscoveryQos;
import io.joynr.exceptions.DiscoveryException;
import io.joynr.exceptions.JoynrRuntimeException;
import io.joynr.jeeintegration.JoynrIntegrationBean;
import io.joynr.jeeintegration.api.ServiceLocator;
import io.joynr.messaging.MessagingQos;
import io.joynr.proxy.GuidedProxyBuilder;
import io.joynr.proxy.ProxyBuilder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.ejb.Singleton;
import javax.inject.Inject;

@Singleton
public class JeeJoynrServiceLocator
implements ServiceLocator {
    private final JoynrIntegrationBean joynrIntegrationBean;

    @Inject
    public JeeJoynrServiceLocator(JoynrIntegrationBean joynrIntegrationBean) {
        this.joynrIntegrationBean = joynrIntegrationBean;
    }

    @Override
    @Deprecated
    public <I> I get(Class<I> serviceInterface, String domain) {
        return this.get(serviceInterface, domain, new MessagingQos(), new DiscoveryQos());
    }

    @Override
    @Deprecated
    public <I> I get(Class<I> serviceInterface, String domain, long ttl) {
        return this.get(serviceInterface, domain, new MessagingQos(ttl), new DiscoveryQos());
    }

    @Override
    @Deprecated
    public <I> I get(Class<I> serviceInterface, Set<String> domains) {
        return this.get(serviceInterface, domains, new MessagingQos(), new DiscoveryQos());
    }

    @Override
    @Deprecated
    public <I> I get(Class<I> serviceInterface, Set<String> domains, long ttl) {
        return this.get(serviceInterface, domains, new MessagingQos(ttl), new DiscoveryQos());
    }

    @Override
    @Deprecated
    public <I> I get(Class<I> serviceInterface, String domain, MessagingQos messagingQos, DiscoveryQos discoveryQos) {
        return this.get(serviceInterface, new HashSet<String>(Arrays.asList(domain)), messagingQos, discoveryQos);
    }

    @Override
    @Deprecated
    public <I> I get(Class<I> serviceInterface, Set<String> domains, MessagingQos messagingQos, DiscoveryQos discoveryQos) {
        return this.get(serviceInterface, domains, messagingQos, discoveryQos, null);
    }

    @Override
    @Deprecated
    public <I> I get(Class<I> serviceInterface, Set<String> domains, MessagingQos messagingQos, DiscoveryQos discoveryQos, String useCase) {
        return this.get(serviceInterface, domains, messagingQos, discoveryQos, useCase, null, null);
    }

    private <I> I get(Class<I> serviceInterface, Set<String> domains, MessagingQos messagingQos, DiscoveryQos discoveryQos, String useCase, String[] gbids, ProxyBuilder.ProxyCreatedCallback<I> proxyCreatedCallback) {
        if (this.joynrIntegrationBean.getRuntime() == null) {
            throw new IllegalStateException("You can't get service proxies until the joynr runtime has been initialised.");
        }
        ProxyBuilder proxyBuilder = this.joynrIntegrationBean.getRuntime().getProxyBuilder(domains, serviceInterface).setMessagingQos(messagingQos).setDiscoveryQos(discoveryQos);
        if (gbids != null) {
            proxyBuilder.setGbids(gbids);
        }
        if (useCase != null) {
            if (serviceInterface.getAnnotation(StatelessAsync.class) == null) {
                throw new IllegalArgumentException("Service interface " + serviceInterface + " is not @StatelessAsync, but you provided a use case for a callback handler.");
            }
            proxyBuilder.setStatelessAsyncCallbackUseCase(useCase);
        } else if (serviceInterface.getAnnotation(StatelessAsync.class) != null) {
            throw new IllegalArgumentException("Service interface " + serviceInterface + " is @StatelessAsync, but you failed to provide a use case.");
        }
        if (proxyCreatedCallback != null) {
            return (I)proxyBuilder.build(proxyCreatedCallback);
        }
        return (I)proxyBuilder.build();
    }

    @Override
    public <I> ServiceLocator.ServiceProxyBuilder<I> builder(Class<I> serviceInterface, String ... domains) {
        if (domains == null || domains.length == 0) {
            throw new JoynrRuntimeException("You must provide at least one domain.");
        }
        HashSet<String> domainSet = new HashSet<String>(Arrays.asList(domains));
        return new JeeJoynrServiceProxyBuilder<I>(serviceInterface, domainSet);
    }

    @Override
    public GuidedProxyBuilder getGuidedProxyBuilder(Class<?> interfaceClass, Set<String> domains) {
        return this.joynrIntegrationBean.getRuntime().getGuidedProxyBuilder(domains, interfaceClass);
    }

    public class JeeJoynrServiceFutureProxyBuilder<T>
    implements ServiceLocator.ServiceProxyBuilder<CompletableFuture<T>> {
        private JeeJoynrServiceProxyBuilder<T> wrappedBuilder;

        private JeeJoynrServiceFutureProxyBuilder(JeeJoynrServiceProxyBuilder<T> wrappedBuilder) {
            this.wrappedBuilder = wrappedBuilder;
        }

        @Override
        public ServiceLocator.ServiceProxyBuilder<CompletableFuture<T>> withTtl(long ttl) {
            this.wrappedBuilder.withTtl(ttl);
            return this;
        }

        @Override
        public ServiceLocator.ServiceProxyBuilder<CompletableFuture<T>> withMessagingQos(MessagingQos messagingQos) {
            this.wrappedBuilder.withMessagingQos(messagingQos);
            return this;
        }

        @Override
        public ServiceLocator.ServiceProxyBuilder<CompletableFuture<T>> withDiscoveryQos(DiscoveryQos discoveryQos) {
            this.wrappedBuilder.withDiscoveryQos(discoveryQos);
            return this;
        }

        @Override
        public ServiceLocator.ServiceProxyBuilder<CompletableFuture<T>> withUseCase(String useCase) {
            this.wrappedBuilder.withUseCase(useCase);
            return this;
        }

        @Override
        public ServiceLocator.ServiceProxyBuilder<CompletableFuture<T>> withGbids(String[] gbids) {
            this.wrappedBuilder.withGbids(gbids);
            return this;
        }

        @Override
        public ServiceLocator.ServiceProxyBuilder<CompletableFuture<T>> withCallback(ProxyBuilder.ProxyCreatedCallback<CompletableFuture<T>> callback) {
            throw new IllegalStateException("The builder is using a future. Attach any callback you want to use in addition to the future before calling useFuture().");
        }

        @Override
        public ServiceLocator.ServiceProxyBuilder<CompletableFuture<CompletableFuture<T>>> useFuture() {
            throw new IllegalStateException("The builder will already provide a future. Ensure that you only call useFuture() once.");
        }

        @Override
        public CompletableFuture<T> build() {
            final CompletableFuture future = new CompletableFuture();
            JeeJoynrServiceLocator.this.get(this.wrappedBuilder.serviceInterface, this.wrappedBuilder.domains, this.wrappedBuilder.messagingQos, this.wrappedBuilder.discoveryQos, this.wrappedBuilder.useCase, this.wrappedBuilder.gbids, new ProxyBuilder.ProxyCreatedCallback<T>(){

                public void onProxyCreationFinished(T result) {
                    future.complete(result);
                    if (JeeJoynrServiceFutureProxyBuilder.this.wrappedBuilder.callback != null) {
                        JeeJoynrServiceFutureProxyBuilder.this.wrappedBuilder.callback.onProxyCreationFinished(result);
                    }
                }

                public void onProxyCreationError(JoynrRuntimeException error) {
                    future.completeExceptionally(error);
                    if (JeeJoynrServiceFutureProxyBuilder.this.wrappedBuilder.callback != null) {
                        JeeJoynrServiceFutureProxyBuilder.this.wrappedBuilder.callback.onProxyCreationError(error);
                    }
                }

                public void onProxyCreationError(DiscoveryException error) {
                    future.completeExceptionally((Throwable)error);
                    if (JeeJoynrServiceFutureProxyBuilder.this.wrappedBuilder.callback != null) {
                        JeeJoynrServiceFutureProxyBuilder.this.wrappedBuilder.callback.onProxyCreationError(error);
                    }
                }
            });
            return future;
        }
    }

    public class JeeJoynrServiceProxyBuilder<T>
    implements ServiceLocator.ServiceProxyBuilder<T> {
        private Class<T> serviceInterface;
        private Set<String> domains;
        private MessagingQos messagingQos = new MessagingQos();
        private DiscoveryQos discoveryQos = new DiscoveryQos();
        private String useCase;
        private String[] gbids;
        private ProxyBuilder.ProxyCreatedCallback<T> callback;

        private JeeJoynrServiceProxyBuilder(Class<T> serviceInterface, Set<String> domains) {
            this.serviceInterface = serviceInterface;
            this.domains = domains;
        }

        @Override
        public ServiceLocator.ServiceProxyBuilder<T> withTtl(long ttl) {
            this.messagingQos.setTtl_ms(ttl);
            return this;
        }

        @Override
        public ServiceLocator.ServiceProxyBuilder<T> withMessagingQos(MessagingQos messagingQos) {
            this.messagingQos = messagingQos != null ? new MessagingQos(messagingQos) : null;
            return this;
        }

        @Override
        public ServiceLocator.ServiceProxyBuilder<T> withDiscoveryQos(DiscoveryQos discoveryQos) {
            this.discoveryQos = discoveryQos != null ? new DiscoveryQos(discoveryQos) : null;
            return this;
        }

        @Override
        public ServiceLocator.ServiceProxyBuilder<T> withUseCase(String useCase) {
            this.useCase = useCase;
            return this;
        }

        @Override
        public ServiceLocator.ServiceProxyBuilder<T> withGbids(String[] gbids) {
            if (gbids == null || gbids.length == 0) {
                throw new IllegalArgumentException("gbids array must not be null or empty");
            }
            this.gbids = (String[])gbids.clone();
            return this;
        }

        @Override
        public ServiceLocator.ServiceProxyBuilder<T> withCallback(ProxyBuilder.ProxyCreatedCallback<T> callback) {
            this.callback = callback;
            return this;
        }

        @Override
        public ServiceLocator.ServiceProxyBuilder<CompletableFuture<T>> useFuture() {
            return new JeeJoynrServiceFutureProxyBuilder(this);
        }

        @Override
        public T build() {
            return JeeJoynrServiceLocator.this.get(this.serviceInterface, this.domains, this.messagingQos, this.discoveryQos, this.useCase, this.gbids, this.callback);
        }
    }
}

