/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.jeeintegration;

import com.google.inject.Injector;
import io.joynr.dispatcher.rpc.MultiReturnValuesContainer;
import io.joynr.exceptions.JoynrException;
import io.joynr.jeeintegration.JoynrJeeMessageMetaInfo;
import io.joynr.jeeintegration.api.ServiceProvider;
import io.joynr.jeeintegration.api.security.JoynrCallingPrincipal;
import io.joynr.jeeintegration.context.JoynrJeeMessageContext;
import io.joynr.jeeintegration.multicast.SubscriptionPublisherInjectionWrapper;
import io.joynr.messaging.JoynrMessageCreator;
import io.joynr.messaging.JoynrMessageMetaInfo;
import io.joynr.provider.AbstractDeferred;
import io.joynr.provider.Deferred;
import io.joynr.provider.DeferredVoid;
import io.joynr.provider.JoynrProvider;
import io.joynr.provider.MultiValueDeferred;
import io.joynr.provider.Promise;
import io.joynr.provider.SubscriptionPublisher;
import io.joynr.provider.SubscriptionPublisherInjection;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.ejb.EJBException;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import joynr.exceptions.ApplicationException;
import joynr.exceptions.ProviderRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProviderWrapper
implements InvocationHandler {
    private static final Logger logger = LoggerFactory.getLogger(ProviderWrapper.class);
    private static final List<Method> OBJECT_METHODS = Arrays.asList(Object.class.getMethods());
    private static final String SET_SUBSCRIPTION_PUBLISHER_METHOD_NAME = "setSubscriptionPublisher";
    private Bean<?> bean;
    private BeanManager beanManager;
    private Injector injector;
    private Class<?> serviceInterface;

    public ProviderWrapper(Bean<?> bean, BeanManager beanManager, Injector injector) {
        ServiceProvider serviceProvider = bean.getBeanClass().getAnnotation(ServiceProvider.class);
        this.serviceInterface = serviceProvider.serviceInterface();
        this.bean = bean;
        this.beanManager = beanManager;
        this.injector = injector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        boolean isJoynrProviderInterfaceMethod = this.matchesJoynrProviderInterfaceMethod(method);
        Method delegateToMethod = this.getMethodFromInterfaces(this.bean.getBeanClass(), method, isJoynrProviderInterfaceMethod);
        Object delegate = this.createDelegateForMethod(method, isJoynrProviderInterfaceMethod);
        boolean isProviderMethod = this.isProviderMethod(method, delegateToMethod);
        Object result = null;
        try {
            if (isProviderMethod) {
                JoynrJeeMessageContext.getInstance().activate();
                this.copyMessageCreatorInfo();
                this.copyMessageContext();
            }
            JoynrException joynrException = null;
            try {
                logger.debug("Invoke provider method {}({}) on {}", new Object[]{method.getName(), args, delegate});
                result = delegateToMethod.invoke(delegate, args);
                logger.debug("Invoke provider method {} returned {}", (Object)method.getName(), result);
            }
            catch (InvocationTargetException e) {
                logger.warn("Invoke provider method {} ERROR: {}", (Object)method.getName(), (Object)e);
                joynrException = this.getJoynrExceptionFromInvocationException(e);
            }
            if (isProviderMethod) {
                Promise promiseResult;
                AbstractDeferred deferred = this.createAndResolveOrRejectDeferred(delegateToMethod, result, joynrException);
                Promise promise = promiseResult = new Promise(deferred);
                return promise;
            }
        }
        finally {
            if (isProviderMethod) {
                JoynrJeeMessageContext.getInstance().deactivate();
            }
        }
        return result;
    }

    private AbstractDeferred createAndResolveOrRejectDeferred(Method method, Object result, JoynrException joynrException) {
        MultiValueDeferred deferred;
        if (result == null && method.getReturnType().getTypeName().equals("void")) {
            deferred = new DeferredVoid();
            if (joynrException == null) {
                ((DeferredVoid)deferred).resolve();
            }
        } else if (result instanceof MultiReturnValuesContainer) {
            deferred = new MultiValueDeferred();
            if (joynrException == null) {
                deferred.resolve(((MultiReturnValuesContainer)result).getValues());
            }
        } else {
            deferred = new Deferred();
            if (joynrException == null) {
                ((Deferred)deferred).resolve(result);
            }
        }
        if (joynrException != null) {
            logger.debug("Provider method invocation resulted in provider runtime exception - rejecting the deferred {} with {}", (Object)deferred, (Object)joynrException);
            if (joynrException instanceof ApplicationException) {
                try {
                    Method rejectMethod = AbstractDeferred.class.getDeclaredMethod("reject", JoynrException.class);
                    rejectMethod.setAccessible(true);
                    rejectMethod.invoke((Object)deferred, joynrException);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    logger.warn("Unable to set {} as rejection reason on {}. Wrapping in ProviderRuntimeException instead.", (Object)joynrException, (Object)deferred);
                    deferred.reject(new ProviderRuntimeException(((ApplicationException)joynrException).getMessage()));
                }
            } else if (joynrException instanceof ProviderRuntimeException) {
                deferred.reject((ProviderRuntimeException)joynrException);
            }
        }
        return deferred;
    }

    private JoynrException getJoynrExceptionFromInvocationException(InvocationTargetException e) throws InvocationTargetException {
        JoynrException joynrException = null;
        Throwable cause = e.getCause();
        if (cause instanceof EJBException) {
            Exception exception = ((EJBException)cause).getCausedByException();
            joynrException = exception instanceof ProviderRuntimeException ? (ProviderRuntimeException)exception : new ProviderRuntimeException("Unexpected exception from provider: " + (exception == null ? cause.toString() : exception.toString()));
        } else if (cause instanceof ProviderRuntimeException || cause instanceof ApplicationException) {
            joynrException = (JoynrException)cause;
        } else if (cause instanceof Exception) {
            joynrException = new ProviderRuntimeException("Unexpected exception from provider: " + cause.toString());
        }
        if (joynrException == null) {
            throw e;
        }
        logger.trace("Returning joynr exception: {}", (Object)joynrException);
        return joynrException;
    }

    private boolean isProviderMethod(Method method, Method delegateToMethod) {
        boolean result;
        boolean bl = result = delegateToMethod != method;
        if (method.getDeclaringClass().equals(SubscriptionPublisherInjection.class)) {
            result = false;
        }
        return result;
    }

    private void copyMessageCreatorInfo() {
        JoynrMessageCreator joynrMessageCreator = (JoynrMessageCreator)this.injector.getInstance(JoynrMessageCreator.class);
        JoynrCallingPrincipal reference = this.getUniqueBeanReference(JoynrCallingPrincipal.class);
        String messageCreatorId = joynrMessageCreator.getMessageCreatorId();
        logger.trace("Setting user '{}' for message processing context.", (Object)messageCreatorId);
        reference.setUsername(messageCreatorId);
    }

    private void copyMessageContext() {
        JoynrMessageMetaInfo joynrMessageContext = (JoynrMessageMetaInfo)this.injector.getInstance(JoynrMessageMetaInfo.class);
        JoynrJeeMessageMetaInfo jeeMessageContext = this.getUniqueBeanReference(JoynrJeeMessageMetaInfo.class);
        logger.trace("Setting message context for message processing context.");
        jeeMessageContext.setMessageContext(joynrMessageContext.getMessageContext());
    }

    private <T> T getUniqueBeanReference(Class<T> beanClass) {
        Set beans = this.beanManager.getBeans(beanClass, new Annotation[0]);
        if (beans.size() != 1) {
            throw new IllegalStateException("There must be exactly one EJB of type " + beanClass.getName() + ". Found " + beans.size());
        }
        Bean bean = (Bean)beans.iterator().next();
        Object reference = this.beanManager.getReference(bean, beanClass, this.beanManager.createCreationalContext((Contextual)bean));
        return (T)reference;
    }

    private Object createDelegateForMethod(Method method, boolean isJoynrProviderInterfaceMethod) {
        if (OBJECT_METHODS.contains(method) || isJoynrProviderInterfaceMethod) {
            return this;
        }
        if (SET_SUBSCRIPTION_PUBLISHER_METHOD_NAME.equals(method.getName()) && SubscriptionPublisherInjection.class.isAssignableFrom(method.getDeclaringClass())) {
            return SubscriptionPublisherInjectionWrapper.createInvocationHandler(this.bean, this.beanManager).createProxy();
        }
        return this.beanManager.getReference(this.bean, this.serviceInterface, this.beanManager.createCreationalContext(this.bean));
    }

    private Method getMethodFromInterfaces(Class<?> beanClass, Method method, boolean isJoynrProviderInterfaceMethod) throws NoSuchMethodException {
        String name = method.getName();
        Class<?>[] parameterTypes = method.getParameterTypes();
        Method result = method;
        if (!isJoynrProviderInterfaceMethod) {
            result = null;
            for (Class<?> interfaceClass : beanClass.getInterfaces()) {
                try {
                    result = interfaceClass.getMethod(name, parameterTypes);
                    if (result == null) continue;
                    logger.trace("Method {} found on interface {}, bean {}", new Object[]{name, interfaceClass, beanClass});
                    break;
                }
                catch (NoSuchMethodException | SecurityException e) {
                    logger.trace("Method {} not found on interface {}", (Object)name, interfaceClass);
                }
            }
        }
        return result == null ? method : result;
    }

    private boolean matchesJoynrProviderInterfaceMethod(Method method) {
        boolean result = false;
        for (Method joynrProviderMethod : JoynrProvider.class.getMethods()) {
            if (!joynrProviderMethod.getName().equals(method.getName()) || !Arrays.equals(joynrProviderMethod.getParameterTypes(), method.getParameterTypes())) continue;
            result = true;
            break;
        }
        return result;
    }

    static {
        try {
            SubscriptionPublisherInjection.class.getMethod(SET_SUBSCRIPTION_PUBLISHER_METHOD_NAME, SubscriptionPublisher.class);
        }
        catch (NoSuchMethodException e) {
            logger.error("Expecting to find method named {} with one argument of type {}, but not found on {}", new Object[]{SET_SUBSCRIPTION_PUBLISHER_METHOD_NAME, SubscriptionPublisher.class, SubscriptionPublisherInjection.class});
        }
    }
}

