/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.jeeintegration;

import io.joynr.jeeintegration.JoynrStatusMetrics;
import io.joynr.messaging.mqtt.statusmetrics.MqttStatusReceiver;
import io.joynr.statusmetrics.MessageWorkerStatus;
import io.joynr.statusmetrics.StatusReceiver;
import java.util.concurrent.ConcurrentHashMap;
import javax.ejb.Singleton;

@Singleton
public class JoynrStatusMetricsAggregator
implements JoynrStatusMetrics,
MqttStatusReceiver,
StatusReceiver {
    private int numDiscardedMqttRequest = 0;
    private boolean isConnectedToMqttBroker = false;
    private long disconnectedFromMqttBrokerSinceTimestamp;
    private ConcurrentHashMap<Integer, MessageWorkerStatus> messageWorkersStatus = new ConcurrentHashMap();

    public synchronized void notifyMessageDropped() {
        ++this.numDiscardedMqttRequest;
    }

    public synchronized void notifyConnectionStatusChanged(MqttStatusReceiver.ConnectionStatus connectionStatus) {
        switch (connectionStatus) {
            case CONNECTED: {
                this.isConnectedToMqttBroker = true;
                this.disconnectedFromMqttBrokerSinceTimestamp = -1L;
                break;
            }
            case NOT_CONNECTED: {
                if (!this.isConnectedToMqttBroker) break;
                this.isConnectedToMqttBroker = false;
                this.disconnectedFromMqttBrokerSinceTimestamp = System.currentTimeMillis();
            }
        }
    }

    @Override
    public synchronized int getNumDiscardedMqttRequests() {
        return this.numDiscardedMqttRequest;
    }

    @Override
    public synchronized boolean isConnectedToMqttBroker() {
        return this.isConnectedToMqttBroker;
    }

    @Override
    public synchronized long getDisconnectedFromMqttBrokerSinceTimestamp() {
        return this.disconnectedFromMqttBrokerSinceTimestamp;
    }

    public void updateMessageWorkerStatus(int messageWorkerId, MessageWorkerStatus messageWorkerStatus) {
        this.messageWorkersStatus.put(messageWorkerId, messageWorkerStatus);
    }
}

