/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.jeeintegration.messaging;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Names;
import io.joynr.accesscontrol.AccessControlClientModule;
import io.joynr.dispatcher.ServletMessageReceiver;
import io.joynr.jeeintegration.messaging.JeeServletMessageReceiver;
import io.joynr.messaging.AbstractMiddlewareMessagingStubFactory;
import io.joynr.messaging.IMessagingSkeleton;
import io.joynr.messaging.IMessagingStub;
import io.joynr.messaging.MessageReceiver;
import io.joynr.messaging.channel.ChannelMessagingSkeleton;
import io.joynr.messaging.channel.ChannelMessagingStubFactory;
import io.joynr.messaging.http.ServletHttpGlobalAddressFactory;
import io.joynr.messaging.http.operation.ApacheHttpRequestFactory;
import io.joynr.messaging.http.operation.HttpClientProvider;
import io.joynr.messaging.http.operation.HttpDefaultRequestConfigProvider;
import io.joynr.messaging.http.operation.HttpRequestFactory;
import io.joynr.messaging.routing.CcMessageRouter;
import io.joynr.messaging.routing.GlobalAddressFactory;
import io.joynr.messaging.routing.MessageRouter;
import io.joynr.messaging.sender.CcMessageSender;
import io.joynr.messaging.sender.MessageSender;
import java.lang.annotation.Annotation;
import joynr.system.RoutingTypes.Address;
import joynr.system.RoutingTypes.ChannelAddress;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;

public class JeeHttpMessagingModule
extends AbstractModule {
    private MapBinder<Class<? extends Address>, IMessagingSkeleton> messagingSkeletonFactory;
    private MapBinder<Class<? extends Address>, AbstractMiddlewareMessagingStubFactory<? extends IMessagingStub, ? extends Address>> messagingStubFactory;

    public JeeHttpMessagingModule(MapBinder<Class<? extends Address>, IMessagingSkeleton> messagingSkeletonFactory, MapBinder<Class<? extends Address>, AbstractMiddlewareMessagingStubFactory<? extends IMessagingStub, ? extends Address>> messagingStubFactory) {
        this.messagingSkeletonFactory = messagingSkeletonFactory;
        this.messagingStubFactory = messagingStubFactory;
    }

    protected void configure() {
        this.messagingSkeletonFactory.addBinding(ChannelAddress.class).to(ChannelMessagingSkeleton.class);
        this.messagingStubFactory.addBinding(ChannelAddress.class).to(ChannelMessagingStubFactory.class);
        Multibinder globalAddresses = Multibinder.newSetBinder((Binder)this.binder(), (TypeLiteral)new TypeLiteral<GlobalAddressFactory<? extends Address>>(){}, (Annotation)Names.named((String)"global_address_provider"));
        globalAddresses.addBinding().to(ServletHttpGlobalAddressFactory.class);
        Multibinder replyToAddresses = Multibinder.newSetBinder((Binder)this.binder(), (TypeLiteral)new TypeLiteral<GlobalAddressFactory<? extends Address>>(){}, (Annotation)Names.named((String)"reply_to_address_provider"));
        replyToAddresses.addBinding().to(ServletHttpGlobalAddressFactory.class);
        this.install((Module)new AccessControlClientModule());
        this.bind(RequestConfig.class).toProvider(HttpDefaultRequestConfigProvider.class).in(Singleton.class);
        this.bind(CloseableHttpClient.class).toProvider(HttpClientProvider.class).in(Singleton.class);
        this.bind(HttpRequestFactory.class).to(ApacheHttpRequestFactory.class);
        this.bind(MessageRouter.class).to(CcMessageRouter.class).in(Singleton.class);
        this.bind(MessageSender.class).to(CcMessageSender.class);
        this.bind(MessageReceiver.class).to(JeeServletMessageReceiver.class);
        this.bind(ServletMessageReceiver.class).to(JeeServletMessageReceiver.class);
    }
}

