/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.jeeintegration.messaging;

import com.google.common.base.Charsets;
import com.google.inject.Injector;
import io.joynr.communications.exceptions.JoynrHttpException;
import io.joynr.dispatcher.ServletMessageReceiver;
import io.joynr.jeeintegration.JoynrIntegrationBean;
import io.joynr.messaging.datatypes.JoynrErrorCode;
import io.joynr.messaging.datatypes.JoynrMessagingErrorCode;
import io.joynr.smrf.EncodingException;
import io.joynr.smrf.UnsuppportedVersionException;
import java.io.IOException;
import java.net.URI;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import joynr.ImmutableMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/channels")
public class JeeMessagingEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(JeeMessagingEndpoint.class);
    private Injector injector;
    private ServletMessageReceiver messageReceiver;

    @Inject
    public JeeMessagingEndpoint(JoynrIntegrationBean jeeIntegrationBean) {
        this.injector = jeeIntegrationBean.getJoynrInjector();
        this.messageReceiver = (ServletMessageReceiver)this.injector.getInstance(ServletMessageReceiver.class);
    }

    @GET
    public Response status() {
        LOG.info("Status called.");
        return Response.status((int)200).build();
    }

    @POST
    @Consumes(value={"application/octet-stream"})
    @Path(value="/{ccid: [A-Z,a-z,0-9,_,\\-,\\.]+}/messageWithoutContentType")
    public Response postMessageWithoutContentType(@PathParam(value="ccid") String ccid, byte[] serializedMessage, @Context UriInfo uriInfo) throws IOException {
        return this.postMessage(ccid, serializedMessage, uriInfo);
    }

    @POST
    @Path(value="/{channelId: [A-Z,a-z,0-9,_,\\-,\\.]+}/message")
    @Produces(value={"application/octet-stream"})
    public Response postMessage(@PathParam(value="channelId") String channelId, byte[] serializedMessage, @Context UriInfo uriInfo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Incoming message:\n" + new String(serializedMessage, Charsets.UTF_8));
        }
        try {
            ImmutableMessage message;
            try {
                message = new ImmutableMessage(serializedMessage);
            }
            catch (EncodingException | UnsuppportedVersionException exception) {
                LOG.error("Failed to deserialize message for channelId {}: {}", (Object)channelId, (Object)exception.getMessage());
                throw new JoynrHttpException(Response.Status.BAD_REQUEST, (JoynrErrorCode)JoynrMessagingErrorCode.JOYNRMESSAGINGERROR_DESERIALIZATIONFAILED);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("POST to channel: {} message: {}", (Object)channelId, (Object)message);
            }
            if (channelId == null) {
                LOG.error("POST message to channel: NULL. message: {} dropped because: channel Id was not set", (Object)message);
                throw new JoynrHttpException(Response.Status.BAD_REQUEST, (JoynrErrorCode)JoynrMessagingErrorCode.JOYNRMESSAGINGERROR_CHANNELNOTSET);
            }
            if (message.getTtlMs() == 0L) {
                LOG.error("POST message to channel: {} message: {} dropped because: TTL not set", (Object)channelId, (Object)message);
                throw new JoynrHttpException(Response.Status.BAD_REQUEST, (JoynrErrorCode)JoynrMessagingErrorCode.JOYNRMESSAGINGERROR_EXPIRYDATENOTSET);
            }
            if (this.messageReceiver == null) {
                LOG.error("POST message to channel: {} message: {} no receiver for the given channel", (Object)channelId, (Object)message);
                return Response.noContent().build();
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("passing off message to messageReceiver: {}", (Object)channelId);
            }
            this.messageReceiver.receive(message);
            URI location = uriInfo.getBaseUriBuilder().path("messages/" + message.getId()).build(new Object[0]);
            return Response.created((URI)location).build();
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error(String.format("POST message to channel: %s error: %s", channelId, e.getMessage()), (Throwable)e);
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

