/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.jeeintegration.messaging;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import io.joynr.jeeintegration.messaging.JeeMqttMessagingSkeletonProvider;
import io.joynr.messaging.AbstractMiddlewareMessagingStubFactory;
import io.joynr.messaging.IMessagingSkeleton;
import io.joynr.messaging.IMessagingStub;
import io.joynr.messaging.mqtt.DefaultMqttClientIdProvider;
import io.joynr.messaging.mqtt.DefaultMqttTopicPrefixProvider;
import io.joynr.messaging.mqtt.MqttClientFactory;
import io.joynr.messaging.mqtt.MqttClientIdProvider;
import io.joynr.messaging.mqtt.MqttGlobalAddressFactory;
import io.joynr.messaging.mqtt.MqttMessagingStubFactory;
import io.joynr.messaging.mqtt.MqttMulticastAddressCalculator;
import io.joynr.messaging.mqtt.MqttReplyToAddressFactory;
import io.joynr.messaging.mqtt.MqttTopicPrefixProvider;
import io.joynr.messaging.mqtt.paho.client.MqttPahoClientFactory;
import io.joynr.messaging.routing.GlobalAddressFactory;
import io.joynr.messaging.routing.MulticastAddressCalculator;
import java.lang.annotation.Annotation;
import joynr.system.RoutingTypes.Address;
import joynr.system.RoutingTypes.MqttAddress;

public class JeeMqttMessageSendingModule
extends AbstractModule {
    public static final String PROPERTY_KEY_MQTT_RECONNECT_SLEEP_MS = "joynr.messaging.mqtt.reconnect.sleepms";
    public static final String PROPERTY_KEY_MQTT_BROKER_URI = "joynr.messaging.mqtt.brokeruri";
    private MapBinder<Class<? extends Address>, AbstractMiddlewareMessagingStubFactory<? extends IMessagingStub, ? extends Address>> messagingStubFactory;
    private MapBinder<Class<? extends Address>, IMessagingSkeleton> messagingSkeletonFactory;

    public JeeMqttMessageSendingModule(MapBinder<Class<? extends Address>, IMessagingSkeleton> messagingSkeletonFactory, MapBinder<Class<? extends Address>, AbstractMiddlewareMessagingStubFactory<? extends IMessagingStub, ? extends Address>> messagingStubFactory) {
        this.messagingSkeletonFactory = messagingSkeletonFactory;
        this.messagingStubFactory = messagingStubFactory;
    }

    @Provides
    @Named(value="property_mqtt_global_address")
    public MqttAddress provideMqttOwnAddress(MqttGlobalAddressFactory globalAddressFactory) {
        return globalAddressFactory.create();
    }

    @Provides
    @Named(value="property_mqtt_reply_to_address")
    public MqttAddress provideMqttOwnAddress(MqttReplyToAddressFactory replyToAddressFactory) {
        return replyToAddressFactory.create();
    }

    protected void configure() {
        this.messagingStubFactory.addBinding(MqttAddress.class).to(MqttMessagingStubFactory.class);
        this.messagingSkeletonFactory.addBinding(MqttAddress.class).toProvider(JeeMqttMessagingSkeletonProvider.class);
        Multibinder globalAddresses = Multibinder.newSetBinder((Binder)this.binder(), (TypeLiteral)new TypeLiteral<GlobalAddressFactory<? extends Address>>(){}, (Annotation)Names.named((String)"global_address_provider"));
        globalAddresses.addBinding().to(MqttGlobalAddressFactory.class);
        Multibinder replyToAddresses = Multibinder.newSetBinder((Binder)this.binder(), (TypeLiteral)new TypeLiteral<GlobalAddressFactory<? extends Address>>(){}, (Annotation)Names.named((String)"reply_to_address_provider"));
        replyToAddresses.addBinding().to(MqttReplyToAddressFactory.class);
        this.bind(MqttClientFactory.class).to(MqttPahoClientFactory.class);
        this.bind(MqttTopicPrefixProvider.class).to(DefaultMqttTopicPrefixProvider.class);
        this.bind(MqttClientIdProvider.class).to(DefaultMqttClientIdProvider.class);
        Multibinder multicastAddressCalculators = Multibinder.newSetBinder((Binder)this.binder(), (TypeLiteral)new TypeLiteral<MulticastAddressCalculator>(){});
        multicastAddressCalculators.addBinding().to(MqttMulticastAddressCalculator.class);
    }
}

