/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.jeeintegration.messaging;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.joynr.jeeintegration.JoynrStatusMetricsAggregator;
import io.joynr.jeeintegration.messaging.NoOpMqttMessagingSkeleton;
import io.joynr.messaging.IMessagingSkeleton;
import io.joynr.messaging.RawMessagingPreprocessor;
import io.joynr.messaging.mqtt.MqttClientFactory;
import io.joynr.messaging.mqtt.MqttMessagingSkeletonProvider;
import io.joynr.messaging.mqtt.MqttTopicPrefixProvider;
import io.joynr.messaging.mqtt.statusmetrics.MqttStatusReceiver;
import io.joynr.messaging.routing.MessageRouter;
import java.util.HashSet;
import joynr.system.RoutingTypes.MqttAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JeeMqttMessagingSkeletonProvider
extends MqttMessagingSkeletonProvider {
    private static final Logger logger = LoggerFactory.getLogger(MqttMessagingSkeletonProvider.class);
    private boolean httpBridgeEnabled;

    @Inject
    public JeeMqttMessagingSkeletonProvider(@Named(value="joynr.jeeintegration.enable.httpbridge") boolean enableHttpBridge, @Named(value="joynr.messaging.mqtt.enable.sharedsubscriptions") boolean enableSharedSubscriptions, @Named(value="property_mqtt_global_address") MqttAddress ownAddress, @Named(value="joynr.messaging.maxincomingmqttrequests") int maxIncomingMqttRequests, @Named(value="joynr.messaging.backpressure.enabled") boolean backpressureEnabled, @Named(value="joynr.messaging.backpressure.incomingmqttrequests.upperthreshold") int backpressureIncomingMqttRequestsUpperThreshold, @Named(value="joynr.messaging.backpressure.incomingmqttrequests.lowerthreshold") int backpressureIncomingMqttRequestsLowerThreshold, @Named(value="property_mqtt_reply_to_address") MqttAddress replyToAddress, MessageRouter messageRouter, MqttClientFactory mqttClientFactory, @Named(value="joynr.messaging.channelid") String channelId, MqttTopicPrefixProvider mqttTopicPrefixProvider, RawMessagingPreprocessor rawMessagingPreprocessor, JoynrStatusMetricsAggregator jeeJoynrStatusMetrics) {
        super(enableSharedSubscriptions, ownAddress, maxIncomingMqttRequests, backpressureEnabled, backpressureIncomingMqttRequestsUpperThreshold, backpressureIncomingMqttRequestsLowerThreshold, replyToAddress, messageRouter, mqttClientFactory, channelId, mqttTopicPrefixProvider, rawMessagingPreprocessor, new HashSet(), (MqttStatusReceiver)jeeJoynrStatusMetrics);
        this.httpBridgeEnabled = enableHttpBridge;
        logger.debug("Created with httpBridgeEnabled: {} ownAddress: {} channelId: {}", new Object[]{this.httpBridgeEnabled, ownAddress, channelId});
    }

    public IMessagingSkeleton get() {
        if (this.httpBridgeEnabled) {
            return new NoOpMqttMessagingSkeleton(this.mqttClientFactory);
        }
        return super.get();
    }
}

