/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.jeeintegration.multicast;

import io.joynr.exceptions.JoynrIllegalStateException;
import io.joynr.jeeintegration.api.SubscriptionPublisher;
import io.joynr.jeeintegration.multicast.SubscriptionPublisherProducer;
import io.joynr.provider.SubscriptionPublisherInjection;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.util.AnnotationLiteral;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionPublisherInjectionWrapper
implements InvocationHandler {
    private static final Logger logger = LoggerFactory.getLogger(SubscriptionPublisherInjectionWrapper.class);
    private static final AnnotationLiteral<SubscriptionPublisher> SUBSCRIPTION_PUBLISHER_ANNOTATION_LITERAL = new AnnotationLiteral<SubscriptionPublisher>(){};
    private final Class<? extends SubscriptionPublisherInjection> proxiedInterface;
    private final Class<? extends io.joynr.provider.SubscriptionPublisher> subscriptionPublisherClass;
    private final Class beanClass;
    private io.joynr.provider.SubscriptionPublisher subscriptionPublisher;
    private SubscriptionPublisherProducer subscriptionPublisherProducer;

    private SubscriptionPublisherInjectionWrapper(Class<? extends SubscriptionPublisherInjection> proxiedInterface, Class<? extends io.joynr.provider.SubscriptionPublisher> subscriptionPublisherClass, SubscriptionPublisherProducer subscriptionPublisherProducer, Class beanClass) {
        this.proxiedInterface = proxiedInterface;
        this.subscriptionPublisherClass = subscriptionPublisherClass;
        this.subscriptionPublisherProducer = subscriptionPublisherProducer;
        this.beanClass = beanClass;
    }

    public static SubscriptionPublisherInjectionWrapper createInvocationHandler(Bean<?> bean, BeanManager beanManager) {
        logger.trace("Called with {} and {}", bean, (Object)beanManager);
        SubscriptionPublisherProducer subscriptionPublisherProducer = SubscriptionPublisherInjectionWrapper.getSubscriptionPublisherProducerReference(beanManager);
        Class<SubscriptionPublisherInjection> proxiedInterface = SubscriptionPublisherInjection.class;
        Class subscriptionPublisherClass = null;
        Class beanClass = bean.getBeanClass();
        for (InjectionPoint injectionPoint : bean.getInjectionPoints()) {
            Type baseType;
            if (!injectionPoint.getQualifiers().contains(SUBSCRIPTION_PUBLISHER_ANNOTATION_LITERAL) || !((baseType = injectionPoint.getAnnotated().getBaseType()) instanceof Class) || !io.joynr.provider.SubscriptionPublisher.class.isAssignableFrom((Class)baseType)) continue;
            subscriptionPublisherClass = (Class)baseType;
            break;
        }
        logger.debug("Found injector {} and publisher {} classes.", proxiedInterface, subscriptionPublisherClass);
        if (subscriptionPublisherClass == null || proxiedInterface == null) {
            throw new JoynrIllegalStateException("Cannot create subscription publisher injection wrapper proxy for bean which doesn't inject a concrete SubscriptionPublisher.");
        }
        return new SubscriptionPublisherInjectionWrapper(proxiedInterface, subscriptionPublisherClass, subscriptionPublisherProducer, beanClass);
    }

    private static SubscriptionPublisherProducer getSubscriptionPublisherProducerReference(BeanManager beanManager) {
        Set beans = beanManager.getBeans(SubscriptionPublisherProducer.class, new Annotation[0]);
        Bean bean = (Bean)beans.iterator().next();
        SubscriptionPublisherProducer reference = (SubscriptionPublisherProducer)beanManager.getReference(bean, SubscriptionPublisherProducer.class, beanManager.createCreationalContext((Contextual)bean));
        logger.trace("Got subscriptionPublisherProducer reference: {}", (Object)reference);
        return reference;
    }

    public Object createProxy() {
        return Proxy.newProxyInstance(this.proxiedInterface.getClassLoader(), new Class[]{this.proxiedInterface}, (InvocationHandler)this);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (args.length == 0 || args[0] == null || !this.subscriptionPublisherClass.isAssignableFrom(args[0].getClass())) {
            throw new JoynrIllegalStateException(String.format("Cannot set the subscription publisher with args %s. First argument must be a non-null instance of a %s.", Arrays.toString(args), this.subscriptionPublisherClass));
        }
        this.subscriptionPublisherProducer.add((io.joynr.provider.SubscriptionPublisher)args[0], this.beanClass);
        return null;
    }
}

