/*-
 * #%L
 * %%
 * Copyright (C) 2018 BMW Car IT GmbH
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */
package io.joynr.jeeintegration;

import io.joynr.jeeintegration.api.JoynrShutdownService;

import javax.ejb.Singleton;
import javax.inject.Inject;

@Singleton
public class JoynrShutdownServiceBean implements JoynrShutdownService {

    @Inject
    private JoynrIntegrationBean joynrIntegrationBean;

    @Override
    public void prepareForShutdown() {
        joynrIntegrationBean.getRuntime().prepareForShutdown();
    }

    @Override
    public void shutdown() {
        joynrIntegrationBean.destroy();
    }
}
