/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.jeeintegration;

import io.joynr.UsedBy;
import io.joynr.jeeintegration.api.CallbackHandler;
import io.joynr.proxy.StatelessAsyncCallback;
import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.function.Consumer;
import javax.ejb.Singleton;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CallbackHandlerDiscovery {
    private static final Logger LOG = LoggerFactory.getLogger(CallbackHandlerDiscovery.class);
    @Inject
    private BeanManager beanManager;

    public void forEach(Consumer<StatelessAsyncCallback> consumer) {
        Set callbackHandlerBeans = this.beanManager.getBeans(Object.class, new Annotation[]{new AnnotationLiteral<CallbackHandler>(){}});
        callbackHandlerBeans.forEach((? super T callbackHandlerBean) -> {
            for (Class<?> interfaceClass : callbackHandlerBean.getBeanClass().getInterfaces()) {
                if (!StatelessAsyncCallback.class.isAssignableFrom(interfaceClass)) continue;
                UsedBy usedBy = interfaceClass.getAnnotation(UsedBy.class);
                if (usedBy == null) {
                    LOG.warn("Stateless async callback interface " + interfaceClass + " implemented by " + callbackHandlerBean + " is not annotated with @UsedBy. Please ensure you have the jee = true property set on the joynr code generator.");
                    continue;
                }
                StatelessAsyncCallback beanReference = (StatelessAsyncCallback)this.beanManager.getReference(callbackHandlerBean, interfaceClass, this.beanManager.createCreationalContext((Contextual)callbackHandlerBean));
                consumer.accept(beanReference);
                break;
            }
        });
    }
}

