/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.jeeintegration;

import io.joynr.StatelessAsync;
import io.joynr.UsedBy;
import io.joynr.arbitration.DiscoveryQos;
import io.joynr.exceptions.JoynrRuntimeException;
import io.joynr.jeeintegration.JoynrIntegrationBean;
import io.joynr.jeeintegration.api.ServiceLocator;
import io.joynr.messaging.MessagingQos;
import io.joynr.proxy.ProxyBuilder;
import io.joynr.util.AnnotationUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.ejb.Singleton;
import javax.inject.Inject;
import joynr.exceptions.ApplicationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class JeeJoynrServiceLocator
implements ServiceLocator {
    private static final Logger LOG = LoggerFactory.getLogger(JeeJoynrServiceLocator.class);
    private final JoynrIntegrationBean joynrIntegrationBean;

    @Inject
    public JeeJoynrServiceLocator(JoynrIntegrationBean joynrIntegrationBean) {
        this.joynrIntegrationBean = joynrIntegrationBean;
    }

    @Override
    public <I> I get(Class<I> serviceInterface, String domain) {
        return this.get(serviceInterface, domain, new MessagingQos(), new DiscoveryQos());
    }

    @Override
    public <I> I get(Class<I> serviceInterface, String domain, long ttl) {
        return this.get(serviceInterface, domain, new MessagingQos(ttl), new DiscoveryQos());
    }

    @Override
    public <I> I get(Class<I> serviceInterface, Set<String> domains) {
        return this.get(serviceInterface, domains, new MessagingQos(), new DiscoveryQos());
    }

    @Override
    public <I> I get(Class<I> serviceInterface, Set<String> domains, long ttl) {
        return this.get(serviceInterface, domains, new MessagingQos(ttl), new DiscoveryQos());
    }

    @Override
    public <I> I get(Class<I> serviceInterface, String domain, MessagingQos messagingQos, DiscoveryQos discoveryQos) {
        return this.get(serviceInterface, new HashSet<String>(Arrays.asList(domain)), messagingQos, discoveryQos);
    }

    @Override
    public <I> I get(Class<I> serviceInterface, Set<String> domains, MessagingQos messagingQos, DiscoveryQos discoveryQos) {
        return this.get(serviceInterface, domains, messagingQos, discoveryQos, null);
    }

    @Override
    public <I> I get(final Class<I> serviceInterface, Set<String> domains, MessagingQos messagingQos, DiscoveryQos discoveryQos, String useCase) {
        if (this.joynrIntegrationBean.getRuntime() == null) {
            throw new IllegalStateException("You can't get service proxies until the joynr runtime has been initialised.");
        }
        final Class<?> joynrProxyInterface = this.findJoynrProxyInterface(serviceInterface);
        ProxyBuilder proxyBuilder = this.joynrIntegrationBean.getRuntime().getProxyBuilder(domains, joynrProxyInterface).setMessagingQos(messagingQos).setDiscoveryQos(discoveryQos);
        if (useCase != null) {
            if (serviceInterface.getAnnotation(StatelessAsync.class) == null) {
                throw new IllegalArgumentException("Service interface " + serviceInterface + " is not @StatelessAsync, but you provided a use case for a callback handler.");
            }
            proxyBuilder.setStatelessAsyncCallbackUseCase(useCase);
        } else if (serviceInterface.getAnnotation(StatelessAsync.class) != null) {
            throw new IllegalArgumentException("Service interface " + serviceInterface + " is @StatelessAsync, but you failed to provide a use case.");
        }
        final Object joynrProxy = proxyBuilder.build();
        return (I)Proxy.newProxyInstance(serviceInterface.getClassLoader(), new Class[]{serviceInterface}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (LOG.isTraceEnabled()) {
                    LOG.trace(String.format("Forwarding call to %s from service interface %s to joynr proxy %s", method, serviceInterface, joynrProxyInterface));
                }
                try {
                    return joynrProxy.getClass().getMethod(method.getName(), method.getParameterTypes()).invoke(joynrProxy, args);
                }
                catch (InvocationTargetException e) {
                    if (e.getTargetException() instanceof JoynrRuntimeException) {
                        throw e.getTargetException();
                    }
                    if (e.getTargetException() instanceof ApplicationException) {
                        throw e.getTargetException();
                    }
                    throw e;
                }
            }
        });
    }

    @Override
    public <I> ServiceLocator.ServiceProxyBuilder<I> builder(Class<I> serviceInterface, String ... domains) {
        if (domains == null || domains.length == 0) {
            throw new JoynrRuntimeException("You must provide at least one domain.");
        }
        HashSet<String> domainSet = new HashSet<String>(Arrays.asList(domains));
        return new JeeJoynrServiceProxyBuilder(serviceInterface, domainSet);
    }

    private <I> Class<?> findJoynrProxyInterface(Class<I> serviceInterface) {
        UsedBy usedByAnnotation = (UsedBy)AnnotationUtil.getAnnotation(serviceInterface, UsedBy.class);
        if (usedByAnnotation == null) {
            throw new IllegalArgumentException(String.format("Unable to find suitable joynr proxy for interface %s", serviceInterface));
        }
        return usedByAnnotation.value();
    }

    public class JeeJoynrServiceProxyBuilder<T>
    implements ServiceLocator.ServiceProxyBuilder<T> {
        private Class<T> serviceInterface;
        private Set<String> domains;
        private MessagingQos messagingQos = new MessagingQos();
        private DiscoveryQos discoveryQos = new DiscoveryQos();
        private String useCase;

        private JeeJoynrServiceProxyBuilder(Class<T> serviceInterface, Set<String> domains) {
            this.serviceInterface = serviceInterface;
            this.domains = domains;
        }

        @Override
        public ServiceLocator.ServiceProxyBuilder<T> withTtl(long ttl) {
            this.messagingQos.setTtl_ms(ttl);
            return this;
        }

        @Override
        public ServiceLocator.ServiceProxyBuilder<T> withMessagingQos(MessagingQos messagingQos) {
            this.messagingQos = messagingQos;
            return this;
        }

        @Override
        public ServiceLocator.ServiceProxyBuilder<T> withDicoveryQos(DiscoveryQos discoveryQos) {
            this.discoveryQos = discoveryQos;
            return this;
        }

        @Override
        public ServiceLocator.ServiceProxyBuilder<T> withUseCase(String useCase) {
            this.useCase = useCase;
            return this;
        }

        @Override
        public T build() {
            return JeeJoynrServiceLocator.this.get(this.serviceInterface, this.domains, this.messagingQos, this.discoveryQos, this.useCase);
        }
    }
}

