/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.jeeintegration;

import io.joynr.jeeintegration.JoynrStatusMetrics;
import io.joynr.messaging.mqtt.statusmetrics.MqttStatusReceiver;
import io.joynr.statusmetrics.MessageWorkerStatus;
import io.joynr.statusmetrics.StatusReceiver;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.Singleton;

@Singleton
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
public class JoynrStatusMetricsAggregator
implements JoynrStatusMetrics,
MqttStatusReceiver,
StatusReceiver {
    private AtomicInteger numDiscardedMqttRequest = new AtomicInteger();
    private Object connectionStatusChangedLock = new Object();
    private AtomicBoolean isConnectedToMqttBroker = new AtomicBoolean();
    private AtomicLong disconnectedFromMqttBrokerSinceTimestamp = new AtomicLong();
    private ConcurrentHashMap<Integer, MessageWorkerStatus> messageWorkersStatus = new ConcurrentHashMap();

    public void notifyMessageDropped() {
        this.numDiscardedMqttRequest.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyConnectionStatusChanged(MqttStatusReceiver.ConnectionStatus connectionStatus) {
        switch (connectionStatus) {
            case CONNECTED: {
                Object object = this.connectionStatusChangedLock;
                synchronized (object) {
                    this.isConnectedToMqttBroker.set(true);
                    this.disconnectedFromMqttBrokerSinceTimestamp.set(-1L);
                    break;
                }
            }
            case NOT_CONNECTED: {
                Object object = this.connectionStatusChangedLock;
                synchronized (object) {
                    if (this.isConnectedToMqttBroker.get()) {
                        this.isConnectedToMqttBroker.set(false);
                        this.disconnectedFromMqttBrokerSinceTimestamp.set(System.currentTimeMillis());
                    }
                    break;
                }
            }
        }
    }

    @Override
    public int getNumDiscardedMqttRequests() {
        return this.numDiscardedMqttRequest.get();
    }

    @Override
    public boolean isConnectedToMqttBroker() {
        return this.isConnectedToMqttBroker.get();
    }

    @Override
    public long getDisconnectedFromMqttBrokerSinceTimestamp() {
        return this.disconnectedFromMqttBrokerSinceTimestamp.get();
    }

    public void updateMessageWorkerStatus(int messageWorkerId, MessageWorkerStatus messageWorkerStatus) {
        this.messageWorkersStatus.put(messageWorkerId, messageWorkerStatus);
    }
}

