/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import io.joynr.messaging.BounceProxyUrl;
import io.joynr.messaging.MessagingSettings;

@Singleton
public class ConfigurableMessagingSettings
implements MessagingSettings {
    public static final String PROPERTY_CC_CONNECTION_TYPE = "joynr.messaging.cc.connectiontype";
    public static final String PROPERTY_CLUSTERCONTROLER_MESSAGING_SKELETON = "joynr.messaging.clustercontrollermessagingskeleton";
    public static final String PROPERTY_ARBITRATION_MINIMUMRETRYDELAY = "joynr.arbitration.minimumretrydelay";
    public static final String PROPERTY_CAPABILITIES_DIRECTORY_PARTICIPANT_ID = "joynr.messaging.capabilitiesdirectoryparticipantid";
    public static final String PROPERTY_CAPABILITIES_DIRECTORY_CHANNEL_ID = "joynr.messaging.capabilitiesdirectorychannelid";
    public static final String PROPERTY_CAPABILITIES_DIRECTORY_ADDRESS = "joynr.messaging.capabilitiesdirectoryaddress";
    public static final String PROPERTY_DISCOVERY_DIRECTORIES_DOMAIN = "joynr.messaging.discoverydirectoriesdomain";
    public static final String PROPERTY_DISCOVERY_REQUEST_TIMEOUT = "joynr.discovery.requesttimeout";
    public static final String PROPERTY_DOMAIN_ACCESS_CONTROLLER_PARTICIPANT_ID = "joynr.messaging.domainaccesscontrollerparticipantid";
    public static final String PROPERTY_DOMAIN_ACCESS_CONTROLLER_CHANNEL_ID = "joynr.messaging.domainaccesscontrollerchannelid";
    public static final String PROPERTY_DOMAIN_ACCESS_CONTROLLER_ADDRESS = "joynr.messaging.domainaccesscontrolleraddress";
    public static final String PROPERTY_CHANNEL_URL_DIRECTORY_PARTICIPANT_ID = "joynr.messaging.channelurldirectoryparticipantid";
    public static final String PROPERTY_CHANNEL_URL_DIRECTORY_CHANNEL_ID = "joynr.messaging.channelurldirectorychannelid";
    public static final String PROPERTY_CHANNEL_URL_DIRECTORY_ADDRESS = "joynr.messaging.channelurldirectoryaddress";
    public static final String PROPERTY_CREATE_CHANNEL_RETRY_INTERVAL_MS = "joynr.messaging.createchannelretryintervalms";
    public static final String PROPERTY_DELETE_CHANNEL_RETRY_INTERVAL_MS = "joynr.messaging.deletechannelretryintervalms";
    public static final String PROPERTY_SEND_MSG_RETRY_INTERVAL_MS = "joynr.messaging.sendmsgretryintervalms";
    public static final String PROPERTY_LONG_POLL_RETRY_INTERVAL_MS = "joynr.messaging.longpollretryintervalms";
    public static final String PROPERTY_MAX_RETRY_COUNT = "joynr.messaging.maxretriescount";
    public static final String PROPERTY_PARTICIPANTIDS_PERSISISTENCE_FILE = "joynr.discovery.participantids_persistence_file";
    public static final String DEFAULT_PARTICIPANTIDS_PERSISTENCE_FILE = "joynr_participantIds.properties";
    public static final String PROPERTY_MESSAGING_MAXIMUM_PARALLEL_SENDS = "joynr.messaging.maximumparallelsends";
    public static final String PROPERTY_HOSTS_FILENAME = "joynr.messaging.hostsfilename";
    private final BounceProxyUrl bounceProxyUrl;
    private final long createChannelRetryIntervalMs;
    private final long deleteChannelRetryIntervalMs;
    private final long sendMsgRetryIntervalMs;
    private final long longPollRetryIntervalMs;
    private final int maxRetriesCount;
    private long discoveryRequestTimeoutMs;
    private int maximumParallelSends;

    @Inject
    public ConfigurableMessagingSettings(@Named(value="joynr.messaging.bounceproxyurl") String bounceProxyUrl, @Named(value="joynr.messaging.maxretriescount") int maxRetriesCount, @Named(value="joynr.messaging.createchannelretryintervalms") long createChannelRetryIntervalMs, @Named(value="joynr.messaging.deletechannelretryintervalms") long deleteChannelRetryIntervalMs, @Named(value="joynr.messaging.sendmsgretryintervalms") long sendMsgRetryIntervalMs, @Named(value="joynr.messaging.longpollretryintervalms") long longPollRetryIntervalMs, @Named(value="joynr.discovery.requesttimeout") long discoveryRequestTimeoutMs, @Named(value="joynr.messaging.maximumparallelsends") int maximumParallelSends) {
        this.maxRetriesCount = maxRetriesCount;
        this.discoveryRequestTimeoutMs = discoveryRequestTimeoutMs;
        this.maximumParallelSends = maximumParallelSends;
        this.bounceProxyUrl = new BounceProxyUrl(bounceProxyUrl);
        this.createChannelRetryIntervalMs = createChannelRetryIntervalMs;
        this.deleteChannelRetryIntervalMs = deleteChannelRetryIntervalMs;
        this.sendMsgRetryIntervalMs = sendMsgRetryIntervalMs;
        this.longPollRetryIntervalMs = longPollRetryIntervalMs;
    }

    public int getMaximumParallelSends() {
        return this.maximumParallelSends;
    }

    @Override
    public BounceProxyUrl getBounceProxyUrl() {
        return this.bounceProxyUrl;
    }

    @Override
    public long getCreateChannelRetryIntervalMs() {
        return this.createChannelRetryIntervalMs;
    }

    @Override
    public long getDeleteChannelRetryIntervalMs() {
        return this.deleteChannelRetryIntervalMs;
    }

    @Override
    public long getSendMsgRetryIntervalMs() {
        return this.sendMsgRetryIntervalMs;
    }

    @Override
    public long getLongPollRetryIntervalMs() {
        return this.longPollRetryIntervalMs;
    }

    public String toString() {
        return "MessagingSettings [bounceProxyUrl=" + this.bounceProxyUrl + ", createChannelRetryIntervalMs=" + this.createChannelRetryIntervalMs + ", sendMsgRetryIntervalMs=" + this.sendMsgRetryIntervalMs + "]";
    }

    @Override
    public int getMaxRetriesCount() {
        return this.maxRetriesCount;
    }

    public long getDiscoveryRequestTimeoutMs() {
        return this.discoveryRequestTimeoutMs;
    }
}

