/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.routing;

import io.joynr.exceptions.JoynrMessageNotSentException;
import io.joynr.exceptions.JoynrSendBufferFullException;
import io.joynr.messaging.IMessaging;
import io.joynr.messaging.routing.MessageRouter;
import io.joynr.messaging.routing.MessagingStubFactory;
import io.joynr.messaging.routing.RoutingTable;
import io.joynr.provider.AbstractDeferred;
import io.joynr.provider.DeferredVoid;
import io.joynr.provider.Promise;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.inject.Inject;
import javax.inject.Singleton;
import joynr.JoynrMessage;
import joynr.system.RoutingAbstractProvider;
import joynr.system.RoutingProvider;
import joynr.system.RoutingTypes.Address;
import joynr.system.RoutingTypes.BrowserAddress;
import joynr.system.RoutingTypes.ChannelAddress;
import joynr.system.RoutingTypes.CommonApiDbusAddress;
import joynr.system.RoutingTypes.WebSocketAddress;
import joynr.system.RoutingTypes.WebSocketClientAddress;
import joynr.types.ProviderQos;
import joynr.types.ProviderScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageRouterImpl
extends RoutingAbstractProvider
implements MessageRouter {
    private Logger logger = LoggerFactory.getLogger(MessageRouterImpl.class);
    private final RoutingTable routingTable;
    private MessagingStubFactory messagingStubFactory;
    private static final int UUID_TAIL = 32;

    @Inject
    @Singleton
    public MessageRouterImpl(RoutingTable routingTable, MessagingStubFactory messagingStubFactory) {
        this.routingTable = routingTable;
        this.messagingStubFactory = messagingStubFactory;
    }

    protected Promise<DeferredVoid> addNextHopInternal(String participantId, Address address) {
        this.routingTable.put(participantId, address);
        DeferredVoid deferred = new DeferredVoid();
        deferred.resolve();
        return new Promise((AbstractDeferred)deferred);
    }

    public Promise<DeferredVoid> addNextHop(String participantId, ChannelAddress channelAddress) {
        return this.addNextHopInternal(participantId, (Address)channelAddress);
    }

    public Promise<DeferredVoid> addNextHop(String participantId, CommonApiDbusAddress commonApiDbusAddress) {
        return this.addNextHopInternal(participantId, (Address)commonApiDbusAddress);
    }

    public Promise<DeferredVoid> addNextHop(String participantId, BrowserAddress browserAddress) {
        return this.addNextHopInternal(participantId, (Address)browserAddress);
    }

    public Promise<DeferredVoid> addNextHop(String participantId, WebSocketAddress webSocketAddress) {
        return this.addNextHopInternal(participantId, (Address)webSocketAddress);
    }

    public Promise<DeferredVoid> addNextHop(String participantId, WebSocketClientAddress webSocketClientAddress) {
        return this.addNextHopInternal(participantId, (Address)webSocketClientAddress);
    }

    public Promise<DeferredVoid> removeNextHop(String participantId) {
        this.routingTable.remove(participantId);
        DeferredVoid deferred = new DeferredVoid();
        deferred.resolve();
        return new Promise((AbstractDeferred)deferred);
    }

    public Promise<RoutingProvider.ResolveNextHopDeferred> resolveNextHop(String participantId) {
        RoutingProvider.ResolveNextHopDeferred deferred = new RoutingProvider.ResolveNextHopDeferred();
        deferred.resolve(Boolean.valueOf(this.routingTable.containsKey(participantId)));
        return new Promise((AbstractDeferred)deferred);
    }

    @CheckForNull
    protected Address getAddress(String toParticipantId) {
        Address address = null;
        if (toParticipantId != null && this.routingTable.containsKey(toParticipantId)) {
            address = this.routingTable.get(toParticipantId);
        }
        return address;
    }

    @Override
    public void route(JoynrMessage message) throws JoynrSendBufferFullException, JoynrMessageNotSentException, IOException {
        String toParticipantId = message.getTo();
        Address address = this.getAddress(toParticipantId);
        if (address == null) {
            throw new JoynrMessageNotSentException("Failed to send Request: No route for given participantId: " + toParticipantId);
        }
        this.routeMessageByAddress(message, address);
    }

    private void routeMessageByAddress(JoynrMessage message, Address address) throws JoynrSendBufferFullException, JoynrMessageNotSentException, IOException {
        String messageId = message.getId().substring(32);
        this.logger.info(">>>>> SEND  ID:{}:{} from: {} to: {} header: {}", (Object[])new String[]{messageId, message.getType(), message.getHeaderValue("from"), message.getHeaderValue("to"), message.getHeader().toString()});
        this.logger.debug(">>>>> body  ID:{}:{}: {}", (Object[])new String[]{messageId, message.getType(), message.getPayload()});
        IMessaging messagingStub = this.messagingStubFactory.create(address);
        messagingStub.transmit(message);
    }

    @Override
    public void addNextHop(String participantId, Address address) {
        this.addNextHopInternal(participantId, address);
    }

    @Override
    public void shutdown() {
        this.messagingStubFactory.shutdown();
    }

    public ProviderQos getProviderQos() {
        ProviderQos providerQos = super.getProviderQos();
        providerQos.setScope(ProviderScope.LOCAL);
        return providerQos;
    }
}

