/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.arbitration;

import com.google.common.collect.Maps;
import io.joynr.arbitration.ArbitrationStrategy;
import io.joynr.arbitration.ArbitrationStrategyFunction;
import io.joynr.arbitration.DiscoveryScope;
import java.util.HashMap;
import java.util.Map;

public class DiscoveryQos {
    public static final DiscoveryQos NO_FILTER;
    private long discoveryTimeout;
    private static final long DEFAULT_DISCOVERYTIMEOUT = 30000L;
    private ArbitrationStrategy arbitrationStrategy;
    private ArbitrationStrategyFunction arbitrationStrategyFunction;
    private static final ArbitrationStrategy DEFAULT_ARBITRATIONSTRATEGY;
    long cacheMaxAge;
    private static final long DEFAULT_CACHEMAXAGE = 0L;
    public static final long NO_MAX_AGE = Long.MAX_VALUE;
    private boolean providerMustSupportOnChange;
    private static final boolean DEFAULT_PROVIDERMUSTSUPPORTONCHANGE = false;
    private long retryInterval;
    private static final long DEFAULT_RETRYINTERVAL = 1000L;
    private DiscoveryScope discoveryScope;
    private static final DiscoveryScope DEFAULT_DISCOVERYSCOPE;
    private HashMap<String, String> customParameters = Maps.newHashMap();

    public DiscoveryQos() {
        this.discoveryTimeout = 30000L;
        this.arbitrationStrategy = DEFAULT_ARBITRATIONSTRATEGY;
        this.cacheMaxAge = 0L;
        this.providerMustSupportOnChange = false;
        this.retryInterval = 1000L;
        this.discoveryScope = DEFAULT_DISCOVERYSCOPE;
    }

    public DiscoveryQos(long discoveryTimeout, ArbitrationStrategy arbitrationStrategy, long cacheMaxAge) {
        this(discoveryTimeout, arbitrationStrategy, cacheMaxAge, DEFAULT_DISCOVERYSCOPE);
    }

    public DiscoveryQos(long discoveryTimeout, ArbitrationStrategyFunction arbitrationStrategyFunction, long cacheMaxAge) {
        this(discoveryTimeout, arbitrationStrategyFunction, cacheMaxAge, DEFAULT_DISCOVERYSCOPE);
    }

    public DiscoveryQos(long discoveryTimeout, ArbitrationStrategy arbitrationStrategy, long cacheMaxAge, DiscoveryScope discoveryScope) {
        if (arbitrationStrategy.equals((Object)ArbitrationStrategy.Custom)) {
            throw new IllegalStateException("A Custom strategy can only be set by passing an arbitration strategy function to the DisocveryQos constructor");
        }
        this.cacheMaxAge = cacheMaxAge;
        this.discoveryScope = discoveryScope;
        this.discoveryTimeout = discoveryTimeout;
        this.arbitrationStrategy = arbitrationStrategy;
        this.retryInterval = 1000L;
        this.providerMustSupportOnChange = false;
    }

    @Deprecated
    public DiscoveryQos(DiscoveryScope discoveryScope, long cacheMaxAge) {
        this();
        this.setCacheMaxAge(cacheMaxAge);
        this.discoveryScope = discoveryScope;
    }

    public DiscoveryQos(long discoveryTimeout, ArbitrationStrategyFunction arbitrationStrategyFunction, long cacheMaxAge, DiscoveryScope discoveryScope) {
        this.arbitrationStrategy = ArbitrationStrategy.Custom;
        this.discoveryTimeout = discoveryTimeout;
        this.arbitrationStrategyFunction = arbitrationStrategyFunction;
        this.cacheMaxAge = cacheMaxAge;
        this.discoveryScope = discoveryScope;
        this.retryInterval = 1000L;
        this.providerMustSupportOnChange = false;
    }

    public void setArbitrationStrategy(ArbitrationStrategy arbitrationStrategy) {
        if (arbitrationStrategy.equals((Object)ArbitrationStrategy.Custom)) {
            throw new IllegalStateException("A Custom strategy can only be set by passing an arbitration strategy function to the DisocveryQos constructor");
        }
        this.arbitrationStrategy = arbitrationStrategy;
    }

    public ArbitrationStrategy getArbitrationStrategy() {
        return this.arbitrationStrategy;
    }

    public void setDiscoveryTimeout(long discoveryTimeout) {
        this.discoveryTimeout = discoveryTimeout;
    }

    public long getDiscoveryTimeout() {
        return this.discoveryTimeout;
    }

    public void addCustomParameter(String key, String value) {
        this.customParameters.put(key, value);
    }

    public Object getCustomParameter(String key) {
        return this.customParameters.get(key);
    }

    public long getCacheMaxAge() {
        return this.cacheMaxAge;
    }

    public void setCacheMaxAge(long cacheMaxAge) {
        this.cacheMaxAge = cacheMaxAge < 0L ? 0L : cacheMaxAge;
    }

    public boolean isLocalOnly() {
        return this.discoveryScope == DiscoveryScope.LOCAL_ONLY;
    }

    public long getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryInterval(long retryInterval) {
        this.retryInterval = retryInterval;
    }

    public boolean getProviderMustSupportOnChange() {
        return this.providerMustSupportOnChange;
    }

    public void setProviderMustSupportOnChange(boolean providerMustSupportOnChange) {
        this.providerMustSupportOnChange = providerMustSupportOnChange;
    }

    public void setDiscoveryScope(DiscoveryScope discoveryScope) {
        this.discoveryScope = discoveryScope;
    }

    public DiscoveryScope getDiscoveryScope() {
        return this.discoveryScope;
    }

    ArbitrationStrategyFunction getArbitrationStrategyFunction() {
        return this.arbitrationStrategyFunction;
    }

    public Map<String, String> getCustomParameters() {
        return this.customParameters;
    }

    static {
        DEFAULT_ARBITRATIONSTRATEGY = ArbitrationStrategy.HighestPriority;
        DEFAULT_DISCOVERYSCOPE = DiscoveryScope.LOCAL_AND_GLOBAL;
        NO_FILTER = new DiscoveryQos(Long.MAX_VALUE, ArbitrationStrategy.NotSet, Long.MAX_VALUE);
    }
}

