/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.routing;

import com.google.inject.Inject;
import io.joynr.exceptions.JoynrMessageNotSentException;
import io.joynr.messaging.AbstractMessagingStubFactory;
import io.joynr.messaging.IMessaging;
import io.joynr.messaging.inprocess.InProcessAddress;
import io.joynr.messaging.inprocess.InProcessMessagingStub;
import java.util.Map;
import joynr.system.RoutingTypes.Address;

public class MessagingStubFactory {
    private Map<Class<? extends Address>, AbstractMessagingStubFactory> messagingStubFactories;

    @Inject
    public MessagingStubFactory(Map<Class<? extends Address>, AbstractMessagingStubFactory> messagingStubFactories) {
        this.messagingStubFactories = messagingStubFactories;
        messagingStubFactories.put(InProcessAddress.class, new AbstractMessagingStubFactory<InProcessAddress>(){

            @Override
            protected IMessaging createInternal(InProcessAddress address) {
                return new InProcessMessagingStub(address.getSkeleton());
            }

            @Override
            public void shutdown() {
            }
        });
    }

    public IMessaging create(Address address) {
        AbstractMessagingStubFactory messagingStubFactory = this.messagingStubFactories.get(address.getClass());
        if (messagingStubFactory == null) {
            throw new JoynrMessageNotSentException("Failed to send Request: Address type not supported");
        }
        return messagingStubFactory.create(address);
    }

    public void shutdown() {
        for (AbstractMessagingStubFactory messagingStubFactory : this.messagingStubFactories.values()) {
            messagingStubFactory.shutdown();
        }
    }
}

