/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.routing;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import io.joynr.messaging.routing.RoutingTable;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import joynr.system.RoutingTypes.Address;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RoutingTableImpl
implements RoutingTable {
    private static final Logger logger = LoggerFactory.getLogger(RoutingTableImpl.class);
    ConcurrentMap<String, Address> hashMap = Maps.newConcurrentMap();

    RoutingTableImpl() {
    }

    @Inject
    public RoutingTableImpl(@Named(value="joynr.messaging.channelurldirectoryparticipantid") String channelUrlDirectoryParticipantId, @Named(value="joynr.messaging.channelurldirectoryaddress") Address channelUrlDirectoryAddress, @Named(value="joynr.messaging.capabilitiesdirectoryparticipantid") String capabilitiesDirectoryParticipantId, @Named(value="joynr.messaging.capabilitiesdirectoryaddress") Address capabiltitiesDirectoryAddress, @Named(value="joynr.messaging.domainaccesscontrollerparticipantid") String domainAccessControllerParticipantId, @Named(value="joynr.messaging.domainaccesscontrolleraddress") Address domainAccessControllerAddress, @Named(value="joynr.messaging.discoveryproviderparticipantid") String discoveryProviderParticipantId, @Named(value="joynr.messaging.discoveryprovideraddress") Address discoveryProviderAddress) {
        this.put(capabilitiesDirectoryParticipantId, capabiltitiesDirectoryAddress);
        this.put(channelUrlDirectoryParticipantId, channelUrlDirectoryAddress);
        this.put(domainAccessControllerParticipantId, domainAccessControllerAddress);
        this.put(discoveryProviderParticipantId, discoveryProviderAddress);
    }

    @Override
    public Address get(String participantId) {
        logger.debug("lookup participant: " + participantId);
        for (Map.Entry eachEntry : this.hashMap.entrySet()) {
            logger.trace((String)eachEntry.getKey() + ": " + eachEntry.getValue());
        }
        return (Address)this.hashMap.get(participantId);
    }

    @Override
    public Address put(String participantId, Address address) {
        logger.debug("adding endpoint address: " + participantId + ": " + address);
        return this.hashMap.putIfAbsent(participantId, address);
    }

    @Override
    public boolean containsKey(String participantId) {
        boolean containsKey = this.hashMap.containsKey(participantId);
        logger.debug("checking for participant: " + participantId + " success: " + containsKey);
        if (!containsKey) {
            for (String eachkey : this.hashMap.keySet()) {
                logger.trace("MessagingEndpointDirectory: " + eachkey + ": " + this.get(eachkey));
            }
        }
        return containsKey;
    }

    @Override
    public void remove(String participantId) {
        this.hashMap.remove(participantId);
    }
}

