/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.datatypes;

import io.joynr.messaging.datatypes.JoynrErrorCode;
import io.joynr.messaging.datatypes.JoynrErrorCodeMapper;

public enum JoynrMessagingErrorCode implements JoynrErrorCode
{
    JOYNRMESSAGINGERROR_CHANNELNOTFOUND(1, "Channel not found"),
    JOYNRMESSAGINGERROR_CHANNELNOTSET(2, "Channel not set"),
    JOYNRMESSAGINGERROR_EXPIRYDATENOTSET(3, "TTL not set"),
    JOYNRMESSAGINGERROR_EXPIRYDATEEXPIRED(4, "TTL expired"),
    JOYNRMESSAGINGERROR_INVALIDMESSAGE(5, "Invalid message"),
    JOYNRMESSAGINGERROR_TRACKINGIDNOTSET(6, "Atmosphere Tracking Id not set"),
    JOYNRMESSAGINGERROR_SESSIONIDSET(7, "Session Id set"),
    JOYNRMESSAGINGERROR_SESSIONIDNOTSET(8, "Session Id not set"),
    JOYNRMESSAGINGERROR_UNDEFINED(0, "Undefined error");

    private static final int OFFSET = 10000;
    private int code;
    private String description;

    private JoynrMessagingErrorCode(int code, String description) {
        this.code = 10000 + code;
        this.description = description;
        JoynrErrorCodeMapper.storeErrorCodeMapping(this);
    }

    public static JoynrMessagingErrorCode getJoynrMessagingErrorCode(int code) {
        JoynrErrorCode errorCode = JoynrErrorCodeMapper.getErrorCode(code);
        if (errorCode == null || !(errorCode instanceof JoynrMessagingErrorCode)) {
            return JOYNRMESSAGINGERROR_UNDEFINED;
        }
        return (JoynrMessagingErrorCode)errorCode;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public static void main(String[] args) {
        System.out.println(JOYNRMESSAGINGERROR_CHANNELNOTFOUND);
        System.out.println(JoynrMessagingErrorCode.getJoynrMessagingErrorCode(10003));
    }
}

