/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.routing;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import io.joynr.messaging.routing.RoutingTable;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import joynr.system.RoutingTypes.Address;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RoutingTableImpl
implements RoutingTable {
    private static final Logger logger = LoggerFactory.getLogger(RoutingTableImpl.class);
    ConcurrentMap<String, Address> hashMap = Maps.newConcurrentMap();

    RoutingTableImpl() {
    }

    @Inject
    public RoutingTableImpl(@Named(value="joynr.messaging.capabilitiesdirectoryparticipantid") String capabilitiesDirectoryParticipantId, @Named(value="joynr.messaging.capabilitiesdirectoryaddress") Address capabiltitiesDirectoryAddress, @Named(value="joynr.messaging.domainaccesscontrollerparticipantid") String domainAccessControllerParticipantId, @Named(value="joynr.messaging.domainaccesscontrolleraddress") Address domainAccessControllerAddress, @Named(value="joynr.messaging.discoveryproviderparticipantid") String discoveryProviderParticipantId, @Named(value="joynr.messaging.ccmessagingaddress") Address discoveryProviderAddress) {
        this.put(capabilitiesDirectoryParticipantId, capabiltitiesDirectoryAddress);
        this.put(domainAccessControllerParticipantId, domainAccessControllerAddress);
        this.put(discoveryProviderParticipantId, discoveryProviderAddress);
    }

    @Override
    public Address get(String participantId) {
        logger.debug("lookup participant: {}", (Object)participantId);
        this.dumpRoutingTableEntry();
        Address result = (Address)this.hashMap.get(participantId);
        logger.debug("Returning: {}", (Object)result);
        return result;
    }

    private void dumpRoutingTableEntry() {
        if (logger.isTraceEnabled()) {
            StringBuilder message = new StringBuilder("Routing table entries:\n");
            for (Map.Entry eachEntry : this.hashMap.entrySet()) {
                message.append("\t> ").append((String)eachEntry.getKey()).append("\t-\t").append(eachEntry.getValue()).append("\n");
            }
            logger.trace(message.toString());
        }
    }

    @Override
    public Address put(String participantId, Address address) {
        logger.debug("adding endpoint address: {} for participant with ID {}", (Object)address, (Object)participantId);
        Address result = this.hashMap.putIfAbsent(participantId, address);
        logger.debug("Returning: {}", (Object)result);
        return result;
    }

    @Override
    public boolean containsKey(String participantId) {
        boolean containsKey = this.hashMap.containsKey(participantId);
        logger.debug("checking for participant: {} success: {}", (Object)participantId, (Object)containsKey);
        if (!containsKey) {
            this.dumpRoutingTableEntry();
        }
        return containsKey;
    }

    @Override
    public void remove(String participantId) {
        this.hashMap.remove(participantId);
    }
}

