/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.serialize;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class JoynrArraySerializer
extends StdSerializer<Object[]> {
    private static final long serialVersionUID = 1L;
    Map<Class<?>, JsonSerializer<Object>> serializers = new HashMap();

    public JoynrArraySerializer() {
        super(Object[].class, false);
    }

    public void serialize(Object[] value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartArray();
        for (Object elem : value) {
            if (elem == null) {
                provider.defaultSerializeNull(gen);
                continue;
            }
            Class<?> clazz = elem.getClass();
            JsonSerializer serializer = this.serializers.get(clazz);
            if (serializer == null) {
                serializer = provider.findTypedValueSerializer(clazz, false, null);
            }
            serializer.serialize(elem, gen, provider);
        }
        gen.writeEndArray();
    }
}

