/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.serialize;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.joynr.exceptions.JoynrMessageNotSentException;
import io.joynr.messaging.JoynrMessageSerializer;
import io.joynr.messaging.serialize.AbstractMiddlewareMessageSerializerFactory;
import java.util.Map;
import joynr.system.RoutingTypes.Address;

public class MessageSerializerFactory {
    public static final String MIDDLEWARE_MESSAGE_SERIALIZER_FACTORIES = "middleware_message_serializer_factories";
    private Map<Class<? extends Address>, AbstractMiddlewareMessageSerializerFactory<? extends Address>> middlewareMessageSerializerFactories;

    @Inject
    public MessageSerializerFactory(@Named(value="middleware_message_serializer_factories") Map<Class<? extends Address>, AbstractMiddlewareMessageSerializerFactory<? extends Address>> middlewareMessageSerializerFactories) {
        this.middlewareMessageSerializerFactories = middlewareMessageSerializerFactories;
    }

    public JoynrMessageSerializer create(Address address) {
        AbstractMiddlewareMessageSerializerFactory<? extends Address> messageSerializerFactory = this.middlewareMessageSerializerFactories.get(address.getClass());
        if (messageSerializerFactory == null) {
            throw new JoynrMessageNotSentException("Failed to find serializer. Address type not supported: " + address.getClass().getCanonicalName());
        }
        return messageSerializerFactory.create((Address)address);
    }

    public void register(Class<? extends Address> address, AbstractMiddlewareMessageSerializerFactory<? extends Address> middlewareMessageSerializerFactory) {
        this.middlewareMessageSerializerFactories.put(address, middlewareMessageSerializerFactory);
    }
}

