/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.routing;

import com.google.common.collect.Maps;
import com.google.inject.Singleton;
import io.joynr.messaging.routing.AddressOperation;
import io.joynr.messaging.routing.RoutingTable;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import joynr.system.RoutingTypes.Address;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RoutingTableImpl
implements RoutingTable {
    private static final Logger logger = LoggerFactory.getLogger(RoutingTableImpl.class);
    private ConcurrentMap<String, Address> hashMap = Maps.newConcurrentMap();

    @Override
    public Address get(String participantId) {
        logger.debug("lookup participant: {}", (Object)participantId);
        this.dumpRoutingTableEntry();
        Address result = (Address)this.hashMap.get(participantId);
        logger.debug("Returning: {}", (Object)result);
        return result;
    }

    private void dumpRoutingTableEntry() {
        if (logger.isTraceEnabled()) {
            StringBuilder message = new StringBuilder("Routing table entries:\n");
            for (Map.Entry eachEntry : this.hashMap.entrySet()) {
                message.append("\t> ").append((String)eachEntry.getKey()).append("\t-\t").append(eachEntry.getValue()).append("\n");
            }
            logger.trace(message.toString());
        }
    }

    @Override
    public Address put(String participantId, Address address) {
        logger.debug("adding endpoint address: {} for participant with ID {}", (Object)address, (Object)participantId);
        Address result = this.hashMap.putIfAbsent(participantId, address);
        logger.debug("Returning: {}", (Object)result);
        return result;
    }

    @Override
    public boolean containsKey(String participantId) {
        boolean containsKey = this.hashMap.containsKey(participantId);
        logger.debug("checking for participant: {} success: {}", (Object)participantId, (Object)containsKey);
        if (!containsKey) {
            this.dumpRoutingTableEntry();
        }
        return containsKey;
    }

    @Override
    public void remove(String participantId) {
        this.hashMap.remove(participantId);
    }

    @Override
    public void apply(AddressOperation addressOperation) {
        if (addressOperation == null) {
            throw new IllegalArgumentException();
        }
        for (Address address : this.hashMap.values()) {
            addressOperation.perform(address);
        }
    }
}

