/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.serialize;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import io.joynr.exceptions.JoynrSerializationException;
import io.joynr.messaging.JoynrMessageSerializer;
import joynr.JoynrMessage;

public class JsonSerializer
implements JoynrMessageSerializer {
    private ObjectMapper objectMapper;

    @Inject
    public JsonSerializer(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public String serialize(JoynrMessage message) throws JoynrSerializationException {
        try {
            return this.objectMapper.writeValueAsString((Object)message);
        }
        catch (JsonProcessingException e) {
            throw new JoynrSerializationException(e.getMessage());
        }
    }

    @Override
    public JoynrMessage deserialize(String serializedMessage) throws JoynrSerializationException {
        try {
            return (JoynrMessage)this.objectMapper.readValue(serializedMessage, JoynrMessage.class);
        }
        catch (Exception e) {
            throw new JoynrSerializationException(e.getMessage());
        }
    }
}

