/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.runtime;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.name.Names;
import io.joynr.guice.IApplication;
import io.joynr.guice.InjectorFactory;
import io.joynr.runtime.JoynrApplication;
import io.joynr.runtime.JoynrApplicationModule;
import java.lang.annotation.Annotation;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJoynrInjectorFactory
extends InjectorFactory<JoynrApplicationModule, JoynrApplication> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractJoynrInjectorFactory.class);

    public AbstractJoynrInjectorFactory(Module ... modules) {
        super(modules);
    }

    public JoynrApplication createApplication(JoynrApplicationModule applicationModule, Module ... applicationSpecificModules) {
        Module[] modules = new Module[applicationSpecificModules != null ? applicationSpecificModules.length + 1 : 1];
        modules[0] = applicationModule;
        if (applicationSpecificModules != null) {
            for (int i = 0; i < applicationSpecificModules.length; ++i) {
                modules[i + 1] = applicationSpecificModules[i];
            }
        }
        Injector fullInjector = this.getInjector().createChildInjector(modules);
        String channelId = (String)fullInjector.getInstance(Key.get(String.class, (Annotation)Names.named((String)"joynr.messaging.channelid")));
        logger.debug("Application using channelId: " + channelId);
        IApplication result = (IApplication)fullInjector.getInstance(IApplication.class);
        if (result instanceof JoynrApplication) {
            return (JoynrApplication)result;
        }
        throw new AssertionError((Object)("The injector factory " + ((Object)((Object)this)).getClass() + " has been configured wrong: io.joynr.guice.IApplication has not been bind to a suptype of " + JoynrApplication.class.getSimpleName()));
    }

    public abstract void updateInjectorModule(Properties var1, Module ... var2);
}

