/*
 * Decompiled with CFR 0.152.
 */
package joynr;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.joynr.common.ExpiryDate;
import io.joynr.subtypes.JoynrType;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class JoynrMessage
implements JoynrType {
    private static final long serialVersionUID = 1L;
    public static final String HEADER_NAME_REPLY_CHANNELID = "replyChannelId";
    public static final String HEADER_NAME_CONTENT_TYPE = "contentType";
    public static final String HEADER_NAME_EXPIRY_DATE = "expiryDate";
    public static final String HEADER_NAME_EFFORT = "effort";
    public static final String HEADER_NAME_MESSAGE_ID = "msgId";
    public static final String HEADER_NAME_CREATOR_USER_ID = "creator";
    public static final String HEADER_NAME_TO_PARTICIPANT_ID = "to";
    public static final String HEADER_NAME_FROM_PARTICIPANT_ID = "from";
    public static final String MESSAGE_TYPE_ONE_WAY = "oneWay";
    public static final String MESSAGE_TYPE_REQUEST = "request";
    public static final String MESSAGE_TYPE_REPLY = "reply";
    public static final String MESSAGE_TYPE_SUBSCRIPTION_REQUEST = "subscriptionRequest";
    public static final String MESSAGE_TYPE_BROADCAST_SUBSCRIPTION_REQUEST = "broadcastSubscriptionRequest";
    public static final String MESSAGE_TYPE_SUBSCRIPTION_REPLY = "subscriptionReply";
    public static final String MESSAGE_TYPE_SUBSCRIPTION_STOP = "subscriptionStop";
    public static final String MESSAGE_TYPE_PUBLICATION = "subscriptionPublication";
    public static final String MESSAGE_CUSTOM_HEADER_PREFIX = "custom-";
    public static final String CONTENT_TYPE_TEXT_PLAIN = "text/plain";
    public static final String CONTENT_TYPE_APPLICATION_JSON = "application/json";
    private String type;
    private Map<String, String> header;
    private String payload;

    public JoynrMessage() {
        this(null, new HashMap<String, String>(), null);
    }

    public JoynrMessage(String type, Map<String, String> header, String payload) {
        this.type = type;
        this.header = header;
        this.payload = payload;
        if (!this.header.containsKey(HEADER_NAME_MESSAGE_ID)) {
            String msgId = UUID.randomUUID().toString();
            this.header.put(HEADER_NAME_MESSAGE_ID, msgId);
        }
    }

    public JoynrMessage(JoynrMessage message) {
        this.type = message.type;
        this.header = new HashMap<String, String>(message.getHeader());
        this.payload = message.payload;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getHeaderValue(String key) {
        return this.header.get(key);
    }

    public void setHeaderValue(String key, String value) {
        this.header.put(key, value);
    }

    public Map<String, String> getHeader() {
        return this.header;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        for (Map.Entry<String, String> entry : customHeaders.entrySet()) {
            this.header.put(MESSAGE_CUSTOM_HEADER_PREFIX + entry.getKey(), entry.getValue());
        }
    }

    public Map<String, String> getCustomHeaders() {
        HashMap<String, String> customHeaders = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.header.entrySet()) {
            if (!entry.getKey().startsWith(MESSAGE_CUSTOM_HEADER_PREFIX)) continue;
            String key = entry.getKey().replaceFirst("^custom-", "");
            customHeaders.put(key, entry.getValue());
        }
        return customHeaders;
    }

    public void setHeader(Map<String, String> newHeaders) {
        this.header.putAll(newHeaders);
    }

    public String getPayload() {
        return this.payload;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("message: ");
        stringBuilder.append(this.getId());
        stringBuilder.append("\r\n  type=");
        stringBuilder.append(this.type);
        stringBuilder.append("\r\n  from=");
        stringBuilder.append(this.header.get(HEADER_NAME_FROM_PARTICIPANT_ID));
        stringBuilder.append("\r\n  to=");
        stringBuilder.append(this.header.get(HEADER_NAME_TO_PARTICIPANT_ID));
        stringBuilder.append("\r\n  header=");
        stringBuilder.append(this.header);
        stringBuilder.append("\r\n  payload=");
        if (this.payload == null) {
            stringBuilder.append("null");
        } else if (this.payload.length() < 1000) {
            stringBuilder.append(this.payload);
        } else {
            stringBuilder.append(this.payload.substring(0, 999) + "...");
        }
        stringBuilder.append("\r\n");
        return stringBuilder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.header == null ? 0 : this.header.hashCode());
        result = 31 * result + (this.payload == null ? 0 : this.payload.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JoynrMessage other = (JoynrMessage)obj;
        if (this.header == null ? other.header != null : !this.header.equals(other.header)) {
            return false;
        }
        if (this.payload == null ? other.payload != null : !this.payload.equals(other.payload)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public String toLogMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("type=");
        stringBuilder.append(this.type);
        stringBuilder.append("\r\nfrom=");
        stringBuilder.append(this.header.get(HEADER_NAME_FROM_PARTICIPANT_ID));
        stringBuilder.append("\r\nto=");
        stringBuilder.append(this.header.get(HEADER_NAME_TO_PARTICIPANT_ID));
        stringBuilder.append("\r\nheader=");
        stringBuilder.append(this.header);
        stringBuilder.append("\r\npayload=");
        if (this.payload == null) {
            stringBuilder.append("null");
        } else if (this.payload.length() < 1000) {
            stringBuilder.append(this.payload);
        } else {
            stringBuilder.append(this.payload.substring(0, 999) + "...");
        }
        stringBuilder.append("\r\n");
        return stringBuilder.toString();
    }

    @JsonIgnore
    public String getId() {
        return this.getHeaderValue(HEADER_NAME_MESSAGE_ID);
    }

    @JsonIgnore
    public String getCreatorUserId() {
        return this.getHeaderValue(HEADER_NAME_CREATOR_USER_ID);
    }

    @JsonIgnore
    public void setCreatorUserId(String creatorUserId) {
        this.setHeaderValue(HEADER_NAME_CREATOR_USER_ID, creatorUserId);
    }

    @JsonIgnore
    public String getFrom() {
        return this.getHeaderValue(HEADER_NAME_FROM_PARTICIPANT_ID);
    }

    @JsonIgnore
    public void setFrom(String fromParticipantId) {
        this.setHeaderValue(HEADER_NAME_FROM_PARTICIPANT_ID, fromParticipantId);
    }

    @JsonIgnore
    public String getTo() {
        return this.getHeaderValue(HEADER_NAME_TO_PARTICIPANT_ID);
    }

    @JsonIgnore
    public void setTo(String toParticipantId) {
        this.setHeaderValue(HEADER_NAME_TO_PARTICIPANT_ID, toParticipantId);
    }

    @JsonIgnore
    public long getExpiryDate() {
        try {
            return Long.parseLong(this.getHeaderValue(HEADER_NAME_EXPIRY_DATE));
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    @JsonIgnore
    public void setExpirationDate(ExpiryDate expirationDate) {
        this.setHeaderValue(HEADER_NAME_EXPIRY_DATE, Long.toString(expirationDate.getValue()));
    }

    @JsonIgnore
    public String getReplyTo() {
        return this.getHeaderValue(HEADER_NAME_REPLY_CHANNELID);
    }

    @JsonIgnore
    public void setReplyTo(String replyToChannelId) {
        this.setHeaderValue(HEADER_NAME_REPLY_CHANNELID, replyToChannelId);
    }
}

