/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.arbitration;

import com.google.common.collect.Maps;
import io.joynr.arbitration.ArbitrationStrategy;
import io.joynr.arbitration.ArbitrationStrategyFunction;
import io.joynr.arbitration.DiscoveryScope;
import java.util.HashMap;
import java.util.Map;

public class DiscoveryQos {
    public static final DiscoveryQos NO_FILTER;
    private long discoveryTimeoutMs;
    private static final long DEFAULT_DISCOVERYTIMEOUT = 30000L;
    private ArbitrationStrategy arbitrationStrategy;
    private ArbitrationStrategyFunction arbitrationStrategyFunction;
    private static final ArbitrationStrategy DEFAULT_ARBITRATIONSTRATEGY;
    long cacheMaxAgeMs;
    private static final long DEFAULT_CACHEMAXAGE = 0L;
    public static final long NO_MAX_AGE = Long.MAX_VALUE;
    private boolean providerMustSupportOnChange;
    private static final boolean DEFAULT_PROVIDERMUSTSUPPORTONCHANGE = false;
    private long retryIntervalMs;
    private static final long DEFAULT_RETRYINTERVAL = 1000L;
    private DiscoveryScope discoveryScope;
    private static final DiscoveryScope DEFAULT_DISCOVERYSCOPE;
    private HashMap<String, String> customParameters = Maps.newHashMap();

    public DiscoveryQos() {
        this.discoveryTimeoutMs = 30000L;
        this.arbitrationStrategy = DEFAULT_ARBITRATIONSTRATEGY;
        this.cacheMaxAgeMs = 0L;
        this.providerMustSupportOnChange = false;
        this.retryIntervalMs = 1000L;
        this.discoveryScope = DEFAULT_DISCOVERYSCOPE;
    }

    public DiscoveryQos(long discoveryTimeout, ArbitrationStrategy arbitrationStrategy, long cacheMaxAge) {
        this(discoveryTimeout, arbitrationStrategy, cacheMaxAge, DEFAULT_DISCOVERYSCOPE);
    }

    public DiscoveryQos(long discoveryTimeout, ArbitrationStrategyFunction arbitrationStrategyFunction, long cacheMaxAge) {
        this(discoveryTimeout, arbitrationStrategyFunction, cacheMaxAge, DEFAULT_DISCOVERYSCOPE);
    }

    public DiscoveryQos(long discoveryTimeout, ArbitrationStrategy arbitrationStrategy, long cacheMaxAge, DiscoveryScope discoveryScope) {
        if (arbitrationStrategy.equals((Object)ArbitrationStrategy.Custom)) {
            throw new IllegalStateException("A Custom strategy can only be set by passing an arbitration strategy function to the DisocveryQos constructor");
        }
        this.cacheMaxAgeMs = cacheMaxAge;
        this.discoveryScope = discoveryScope;
        this.discoveryTimeoutMs = discoveryTimeout;
        this.arbitrationStrategy = arbitrationStrategy;
        this.retryIntervalMs = 1000L;
        this.providerMustSupportOnChange = false;
    }

    @Deprecated
    public DiscoveryQos(DiscoveryScope discoveryScope, long cacheMaxAge) {
        this();
        this.setCacheMaxAgeMs(cacheMaxAge);
        this.discoveryScope = discoveryScope;
    }

    public DiscoveryQos(long discoveryTimeout, ArbitrationStrategyFunction arbitrationStrategyFunction, long cacheMaxAge, DiscoveryScope discoveryScope) {
        this.arbitrationStrategy = ArbitrationStrategy.Custom;
        this.discoveryTimeoutMs = discoveryTimeout;
        this.arbitrationStrategyFunction = arbitrationStrategyFunction;
        this.cacheMaxAgeMs = cacheMaxAge;
        this.discoveryScope = discoveryScope;
        this.retryIntervalMs = 1000L;
        this.providerMustSupportOnChange = false;
    }

    public void setArbitrationStrategy(ArbitrationStrategy arbitrationStrategy) {
        if (arbitrationStrategy.equals((Object)ArbitrationStrategy.Custom)) {
            throw new IllegalStateException("A Custom strategy can only be set by passing an arbitration strategy function to the DisocveryQos constructor");
        }
        this.arbitrationStrategy = arbitrationStrategy;
    }

    public ArbitrationStrategy getArbitrationStrategy() {
        return this.arbitrationStrategy;
    }

    public void setDiscoveryTimeoutMs(long discoveryTimeoutMs) {
        this.discoveryTimeoutMs = discoveryTimeoutMs;
    }

    public long getDiscoveryTimeoutMs() {
        return this.discoveryTimeoutMs;
    }

    public void addCustomParameter(String key, String value) {
        this.customParameters.put(key, value);
    }

    public Object getCustomParameter(String key) {
        return this.customParameters.get(key);
    }

    public long getCacheMaxAgeMs() {
        return this.cacheMaxAgeMs;
    }

    public void setCacheMaxAgeMs(long cacheMaxAgeMs) {
        this.cacheMaxAgeMs = cacheMaxAgeMs < 0L ? 0L : cacheMaxAgeMs;
    }

    public boolean isLocalOnly() {
        return this.discoveryScope == DiscoveryScope.LOCAL_ONLY;
    }

    public long getRetryIntervalMs() {
        return this.retryIntervalMs;
    }

    public void setRetryIntervalMs(long retryIntervalMs) {
        this.retryIntervalMs = retryIntervalMs;
    }

    public boolean getProviderMustSupportOnChange() {
        return this.providerMustSupportOnChange;
    }

    public void setProviderMustSupportOnChange(boolean providerMustSupportOnChange) {
        this.providerMustSupportOnChange = providerMustSupportOnChange;
    }

    public void setDiscoveryScope(DiscoveryScope discoveryScope) {
        this.discoveryScope = discoveryScope;
    }

    public DiscoveryScope getDiscoveryScope() {
        return this.discoveryScope;
    }

    ArbitrationStrategyFunction getArbitrationStrategyFunction() {
        return this.arbitrationStrategyFunction;
    }

    public Map<String, String> getCustomParameters() {
        return this.customParameters;
    }

    @Deprecated
    public long getCacheMaxAge() {
        return this.getCacheMaxAgeMs();
    }

    @Deprecated
    public void setCacheMaxAge(long cacheMaxAgeMs) {
        this.setCacheMaxAgeMs(cacheMaxAgeMs);
    }

    @Deprecated
    public long getDiscoveryTimeout() {
        return this.getDiscoveryTimeoutMs();
    }

    @Deprecated
    public void setDiscoveryTimeout(long discoveryTimeoutMs) {
        this.setDiscoveryTimeoutMs(discoveryTimeoutMs);
    }

    @Deprecated
    public long getRetryInterval() {
        return this.getRetryIntervalMs();
    }

    @Deprecated
    public void setRetryInterval(long retryIntervalMs) {
        this.setRetryIntervalMs(retryIntervalMs);
    }

    static {
        DEFAULT_ARBITRATIONSTRATEGY = ArbitrationStrategy.HighestPriority;
        DEFAULT_DISCOVERYSCOPE = DiscoveryScope.LOCAL_AND_GLOBAL;
        NO_FILTER = new DiscoveryQos(Long.MAX_VALUE, ArbitrationStrategy.NotSet, Long.MAX_VALUE);
    }
}

