/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.serialize;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.NonTypedScalarSerializerBase;
import com.fasterxml.jackson.databind.ser.std.NumberSerializers;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class NumberSerializer
extends NonTypedScalarSerializerBase<Number> {
    Map<Class<?>, JsonSerializer<?>> serializers = new HashMap();

    public NumberSerializer() {
        super(Number.class);
        NumberSerializers.IntLikeSerializer intLikeSerializer = new NumberSerializers.IntLikeSerializer();
        this.serializers.put(Byte.class, (JsonSerializer<?>)intLikeSerializer);
        this.serializers.put(Short.class, (JsonSerializer<?>)intLikeSerializer);
        this.serializers.put(Integer.class, (JsonSerializer<?>)new NumberSerializers.IntegerSerializer());
        this.serializers.put(Long.class, (JsonSerializer<?>)new NumberSerializers.LongSerializer());
        this.serializers.put(Float.class, (JsonSerializer<?>)new NumberSerializers.FloatSerializer());
        this.serializers.put(Double.class, (JsonSerializer<?>)new NumberSerializers.DoubleSerializer());
    }

    public void serialize(Number value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        JsonSerializer<?> serializer = this.serializers.get(value.getClass());
        if (serializer == null) {
            throw new IllegalArgumentException("serialze called on type that is not supported: " + value.getClass());
        }
        serializer.serialize((Object)value, jgen, provider);
    }
}

