/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.routing;

import io.joynr.messaging.routing.MessageRouter;
import io.joynr.provider.AbstractDeferred;
import io.joynr.provider.DeferredVoid;
import io.joynr.provider.Promise;
import javax.inject.Inject;
import joynr.system.RoutingAbstractProvider;
import joynr.system.RoutingProvider;
import joynr.system.RoutingTypes.Address;
import joynr.system.RoutingTypes.BrowserAddress;
import joynr.system.RoutingTypes.ChannelAddress;
import joynr.system.RoutingTypes.CommonApiDbusAddress;
import joynr.system.RoutingTypes.MqttAddress;
import joynr.system.RoutingTypes.WebSocketAddress;
import joynr.system.RoutingTypes.WebSocketClientAddress;

public class RoutingProviderImpl
extends RoutingAbstractProvider {
    private MessageRouter messageRouter;

    @Inject
    public RoutingProviderImpl(MessageRouter messageRouter) {
        this.messageRouter = messageRouter;
    }

    private Promise<DeferredVoid> resolvedDeferred() {
        DeferredVoid deferred = new DeferredVoid();
        deferred.resolve();
        return new Promise((AbstractDeferred)deferred);
    }

    public Promise<DeferredVoid> addNextHop(String participantId, ChannelAddress address) {
        this.messageRouter.addNextHop(participantId, (Address)address);
        return this.resolvedDeferred();
    }

    public Promise<DeferredVoid> addNextHop(String participantId, MqttAddress address) {
        this.messageRouter.addNextHop(participantId, (Address)address);
        return this.resolvedDeferred();
    }

    public Promise<DeferredVoid> addNextHop(String participantId, CommonApiDbusAddress address) {
        this.messageRouter.addNextHop(participantId, (Address)address);
        return this.resolvedDeferred();
    }

    public Promise<DeferredVoid> addNextHop(String participantId, BrowserAddress address) {
        this.messageRouter.addNextHop(participantId, (Address)address);
        return this.resolvedDeferred();
    }

    public Promise<DeferredVoid> addNextHop(String participantId, WebSocketAddress address) {
        this.messageRouter.addNextHop(participantId, (Address)address);
        return this.resolvedDeferred();
    }

    public Promise<DeferredVoid> addNextHop(String participantId, WebSocketClientAddress address) {
        this.messageRouter.addNextHop(participantId, (Address)address);
        return this.resolvedDeferred();
    }

    public Promise<DeferredVoid> removeNextHop(String participantId) {
        this.messageRouter.removeNextHop(participantId);
        return this.resolvedDeferred();
    }

    public Promise<RoutingProvider.ResolveNextHopDeferred> resolveNextHop(String participantId) {
        boolean resolved = this.messageRouter.resolveNextHop(participantId);
        RoutingProvider.ResolveNextHopDeferred deferred = new RoutingProvider.ResolveNextHopDeferred();
        deferred.resolve(Boolean.valueOf(resolved));
        return new Promise((AbstractDeferred)deferred);
    }

    public Promise<DeferredVoid> addMulticastReceiver(String multicastId, String subscriberParticipantId, String providerParticipantId) {
        this.messageRouter.addMulticastReceiver(multicastId, subscriberParticipantId, providerParticipantId);
        return this.resolvedDeferred();
    }

    public Promise<DeferredVoid> removeMulticastReceiver(String multicastId, String subscriberParticipantId, String providerParticipantId) {
        this.messageRouter.removeMulticastReceiver(multicastId, subscriberParticipantId, providerParticipantId);
        return this.resolvedDeferred();
    }
}

