/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.routing;

import com.google.inject.name.Named;
import io.joynr.exceptions.JoynrDelayMessageException;
import io.joynr.exceptions.JoynrMessageNotSentException;
import io.joynr.exceptions.JoynrRuntimeException;
import io.joynr.exceptions.JoynrSendBufferFullException;
import io.joynr.exceptions.JoynrShutdownException;
import io.joynr.messaging.FailureAction;
import io.joynr.messaging.IMessagingMulticastSubscriber;
import io.joynr.messaging.IMessagingSkeleton;
import io.joynr.messaging.IMessagingStub;
import io.joynr.messaging.MessagingSkeletonFactory;
import io.joynr.messaging.routing.AddressManager;
import io.joynr.messaging.routing.MessageRouter;
import io.joynr.messaging.routing.MessagingStubFactory;
import io.joynr.messaging.routing.MulticastReceiverRegistry;
import io.joynr.messaging.routing.RoutingTable;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import joynr.ImmutableMessage;
import joynr.system.RoutingTypes.Address;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMessageRouter
implements MessageRouter {
    private static final long TERMINATION_TIMEOUT = 5000L;
    private Logger logger = LoggerFactory.getLogger(AbstractMessageRouter.class);
    private final RoutingTable routingTable;
    private static final DateFormat DateFormatter = new SimpleDateFormat("dd/MM HH:mm:ss:sss");
    private ScheduledExecutorService scheduler;
    private long sendMsgRetryIntervalMs;
    private MessagingStubFactory messagingStubFactory;
    private final MessagingSkeletonFactory messagingSkeletonFactory;
    private AddressManager addressManager;
    protected final MulticastReceiverRegistry multicastReceiverRegistry;

    @Inject
    @Singleton
    public AbstractMessageRouter(RoutingTable routingTable, @Named(value="io.joynr.messaging.scheduledthreadpool") ScheduledExecutorService scheduler, @Named(value="joynr.messaging.sendmsgretryintervalms") long sendMsgRetryIntervalMs, MessagingStubFactory messagingStubFactory, MessagingSkeletonFactory messagingSkeletonFactory, AddressManager addressManager, MulticastReceiverRegistry multicastReceiverRegistry) {
        this.routingTable = routingTable;
        this.scheduler = scheduler;
        this.sendMsgRetryIntervalMs = sendMsgRetryIntervalMs;
        this.messagingStubFactory = messagingStubFactory;
        this.messagingSkeletonFactory = messagingSkeletonFactory;
        this.addressManager = addressManager;
        this.multicastReceiverRegistry = multicastReceiverRegistry;
    }

    @Override
    public void removeNextHop(String participantId) {
        this.routingTable.remove(participantId);
    }

    @Override
    public boolean resolveNextHop(String participantId) {
        return this.routingTable.containsKey(participantId);
    }

    @Override
    public void addMulticastReceiver(final String multicastId, String subscriberParticipantId, String providerParticipantId) {
        this.logger.trace("Adding multicast receiver {} for multicast {} on provider {}", new Object[]{subscriberParticipantId, multicastId, providerParticipantId});
        this.multicastReceiverRegistry.registerMulticastReceiver(multicastId, subscriberParticipantId);
        this.performSubscriptionOperation(multicastId, providerParticipantId, new SubscriptionOperation(){

            @Override
            public void perform(IMessagingMulticastSubscriber messagingMulticastSubscriber) {
                messagingMulticastSubscriber.registerMulticastSubscription(multicastId);
            }
        });
    }

    @Override
    public void removeMulticastReceiver(final String multicastId, String subscriberParticipantId, String providerParticipantId) {
        this.multicastReceiverRegistry.unregisterMulticastReceiver(multicastId, subscriberParticipantId);
        this.performSubscriptionOperation(multicastId, providerParticipantId, new SubscriptionOperation(){

            @Override
            public void perform(IMessagingMulticastSubscriber messagingMulticastSubscriber) {
                messagingMulticastSubscriber.unregisterMulticastSubscription(multicastId);
            }
        });
    }

    private void performSubscriptionOperation(String multicastId, String providerParticipantId, SubscriptionOperation operation) {
        Address providerAddress = this.routingTable.get(providerParticipantId);
        IMessagingSkeleton messagingSkeleton = this.messagingSkeletonFactory.getSkeleton(providerAddress);
        if (messagingSkeleton != null && messagingSkeleton instanceof IMessagingMulticastSubscriber) {
            operation.perform((IMessagingMulticastSubscriber)((Object)messagingSkeleton));
        } else {
            this.logger.trace("No messaging skeleton found for address {}, not performing multicast subscription.", (Object)providerAddress);
        }
    }

    @Override
    public void addNextHop(String participantId, Address address, boolean isGloballyVisible) {
        this.routingTable.put(participantId, address, isGloballyVisible);
    }

    @Override
    public void route(ImmutableMessage message) {
        this.checkExpiry(message);
        this.routeInternal(message, 0L, 0);
    }

    protected void schedule(Runnable runnable, String messageId, long delay, TimeUnit timeUnit) {
        if (this.scheduler.isShutdown()) {
            JoynrShutdownException joynrShutdownEx = new JoynrShutdownException("MessageScheduler is shutting down already. Unable to send message [messageId: " + messageId + "].");
            throw joynrShutdownEx;
        }
        this.scheduler.schedule(runnable, delay, timeUnit);
    }

    protected Set<Address> getAddresses(ImmutableMessage message) {
        return this.addressManager.getAddresses(message);
    }

    private void routeInternal(final ImmutableMessage message, long delayMs, final int retriesCount) {
        try {
            this.logger.trace("Scheduling {} with delay {} and retries {}", new Object[]{message, delayMs, retriesCount});
            this.schedule(new Runnable(){

                @Override
                public void run() {
                    AbstractMessageRouter.this.logger.trace("Starting processing of message {}", (Object)message);
                    try {
                        AbstractMessageRouter.this.checkExpiry(message);
                        Set<Address> addresses = AbstractMessageRouter.this.getAddresses(message);
                        if (addresses.isEmpty()) {
                            throw new JoynrMessageNotSentException("Failed to send Request: No route for given participantId: " + message.getRecipient());
                        }
                        for (Address address : addresses) {
                            AbstractMessageRouter.this.logger.trace(">>>>> SEND  {}", (Object)message.toLogMessage());
                            IMessagingStub messagingStub = AbstractMessageRouter.this.messagingStubFactory.create(address);
                            messagingStub.transmit(message, AbstractMessageRouter.this.createFailureAction(message, retriesCount));
                        }
                    }
                    catch (Exception error) {
                        AbstractMessageRouter.this.logger.error("error in scheduled message router thread: {}", (Object)error.getMessage());
                        FailureAction failureAction = AbstractMessageRouter.this.createFailureAction(message, retriesCount);
                        failureAction.execute(error);
                    }
                }
            }, message.getId(), delayMs, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException e) {
            this.logger.error("Execution rejected while scheduling SendSerializedMessageRequest ", (Throwable)e);
            throw new JoynrSendBufferFullException(e);
        }
    }

    private void checkExpiry(ImmutableMessage message) {
        if (!message.isTtlAbsolute()) {
            throw new JoynrRuntimeException("Relative ttl not supported");
        }
        long currentTimeMillis = System.currentTimeMillis();
        long ttlExpirationDateMs = message.getTtlMs();
        if (ttlExpirationDateMs <= currentTimeMillis) {
            String errorMessage = MessageFormat.format("ttl must be greater than 0 / ttl timestamp must be in the future: now: {0} abs_ttl: {1}", currentTimeMillis, ttlExpirationDateMs);
            this.logger.error(errorMessage);
            throw new JoynrMessageNotSentException(errorMessage);
        }
    }

    private FailureAction createFailureAction(final ImmutableMessage message, final int retriesCount) {
        FailureAction failureAction = new FailureAction(){
            final String messageId;
            {
                this.messageId = message.getId();
            }

            @Override
            public void execute(Throwable error) {
                long delayMs;
                if (error instanceof JoynrShutdownException) {
                    AbstractMessageRouter.this.logger.warn("{}", (Object)error.getMessage());
                    return;
                }
                if (error instanceof JoynrMessageNotSentException) {
                    AbstractMessageRouter.this.logger.error(" ERROR SENDING:  aborting send of messageId: {}. Error: {}", new Object[]{this.messageId, error.getMessage()});
                    return;
                }
                AbstractMessageRouter.this.logger.warn("PROBLEM SENDING, will retry. messageId: {}. Error: {} Message: {}", new Object[]{this.messageId, error.getClass().getName(), error.getMessage()});
                if (error instanceof JoynrDelayMessageException) {
                    delayMs = ((JoynrDelayMessageException)error).getDelayMs();
                } else {
                    delayMs = AbstractMessageRouter.this.sendMsgRetryIntervalMs;
                    delayMs += AbstractMessageRouter.this.exponentialBackoff(delayMs, retriesCount);
                }
                try {
                    AbstractMessageRouter.this.logger.error("Rescheduling messageId: {} with delay " + delayMs + " ms, TTL is: {} ms", (Object)this.messageId, (Object)DateFormatter.format(message.getTtlMs()));
                    AbstractMessageRouter.this.routeInternal(message, delayMs, retriesCount + 1);
                    return;
                }
                catch (JoynrSendBufferFullException e) {
                    try {
                        AbstractMessageRouter.this.logger.error("Rescheduling message: {} delayed {} ms because send buffer is full", (Object)delayMs, (Object)this.messageId);
                        Thread.sleep(delayMs);
                        this.execute(e);
                    }
                    catch (InterruptedException e1) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                    return;
                }
            }
        };
        return failureAction;
    }

    @Override
    public void shutdown() {
        this.scheduler.shutdown();
        try {
            if (!this.scheduler.awaitTermination(5000L, TimeUnit.MILLISECONDS)) {
                this.logger.error("Message Scheduler did not shut down in time. Timedout out waiting for executor service to shutdown after {}ms.", (Object)5000L);
                this.logger.debug("Attempting to shutdown scheduler {} forcibly.", (Object)this.scheduler);
                this.scheduler.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.logger.error("Message Scheduler shutdown interrupted: {}", (Object)e.getMessage());
        }
    }

    private long exponentialBackoff(long delayMs, int retries) {
        this.logger.trace("TRIES: " + retries);
        long millis = delayMs + (long)((double)((long)(2 ^ retries) * delayMs) * Math.random());
        this.logger.trace("MILLIS: " + millis);
        return millis;
    }

    private static interface SubscriptionOperation {
        public void perform(IMessagingMulticastSubscriber var1);
    }
}

