/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.routing;

import com.google.common.collect.Maps;
import com.google.inject.Singleton;
import io.joynr.exceptions.JoynrRuntimeException;
import io.joynr.messaging.routing.AddressOperation;
import io.joynr.messaging.routing.RoutingTable;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import joynr.system.RoutingTypes.Address;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RoutingTableImpl
implements RoutingTable {
    private static final Logger logger = LoggerFactory.getLogger(RoutingTableImpl.class);
    private ConcurrentMap<String, RoutingEntry> hashMap = Maps.newConcurrentMap();

    @Override
    public Address get(String participantId) {
        logger.trace("entering get(participantId={})", (Object)participantId);
        this.dumpRoutingTableEntry();
        RoutingEntry routingEntry = (RoutingEntry)this.hashMap.get(participantId);
        if (routingEntry == null) {
            return null;
        }
        logger.trace("leaving get(participantId={}) = {}", (Object)routingEntry.getAddress());
        return routingEntry.getAddress();
    }

    private void dumpRoutingTableEntry() {
        if (logger.isTraceEnabled()) {
            StringBuilder message = new StringBuilder("Routing table entries:\n");
            for (Map.Entry eachEntry : this.hashMap.entrySet()) {
                message.append("\t> ").append((String)eachEntry.getKey()).append("\t-\t").append(((RoutingEntry)eachEntry.getValue()).address).append("\t-\t").append(((RoutingEntry)eachEntry.getValue()).isGloballyVisible).append("\n");
            }
            logger.trace(message.toString());
        }
    }

    @Override
    public Address put(String participantId, Address address, boolean isGloballyVisible) {
        logger.trace("entering put(participantId={}, address={}, isGloballyVisible={})", new Object[]{participantId, address, isGloballyVisible});
        RoutingEntry routingEntry = new RoutingEntry(address, isGloballyVisible);
        RoutingEntry result = this.hashMap.putIfAbsent(participantId, routingEntry);
        if (result != null) {
            if (!address.equals((Object)result.getAddress()) || result.getIsGloballyVisible() != isGloballyVisible) {
                logger.warn("unable to update(participantId={}, address={}, isGloballyVisible={}) into routing table, since the participant ID is already associated with routing entry address={}, isGloballyVisible={}", new Object[]{participantId, address, isGloballyVisible, address, isGloballyVisible});
            }
            return result.getAddress();
        }
        logger.trace("put(participantId={}, address={}, isGloballyVisible={}) successfully into routing table", new Object[]{participantId, address, isGloballyVisible});
        return null;
    }

    @Override
    public boolean containsKey(String participantId) {
        boolean containsKey = this.hashMap.containsKey(participantId);
        logger.trace("checking for participant: {} success: {}", (Object)participantId, (Object)containsKey);
        if (!containsKey) {
            this.dumpRoutingTableEntry();
        }
        return containsKey;
    }

    @Override
    public boolean getIsGloballyVisible(String participantId) {
        RoutingEntry routingEntry = (RoutingEntry)this.hashMap.get(participantId);
        if (routingEntry == null) {
            throw new JoynrRuntimeException("participateId doesn't exist in the routing table");
        }
        return routingEntry.getIsGloballyVisible();
    }

    @Override
    public void remove(String participantId) {
        this.hashMap.remove(participantId);
    }

    @Override
    public void apply(AddressOperation addressOperation) {
        if (addressOperation == null) {
            throw new IllegalArgumentException();
        }
        for (RoutingEntry routingEntry : this.hashMap.values()) {
            addressOperation.perform(routingEntry.getAddress());
        }
    }

    private static class RoutingEntry {
        private Address address;
        private boolean isGloballyVisible;

        RoutingEntry(Address address, boolean isGloballyVisible) {
            this.setAddress(address);
            this.setIsGloballyVisible(isGloballyVisible);
        }

        public Address getAddress() {
            return this.address;
        }

        public boolean getIsGloballyVisible() {
            return this.isGloballyVisible;
        }

        public void setAddress(Address address) {
            this.address = address;
        }

        public void setIsGloballyVisible(boolean isGloballyVisible) {
            this.isGloballyVisible = isGloballyVisible;
        }
    }
}

