/*
 * Decompiled with CFR 0.152.
 */
package joynr;

import io.joynr.smrf.EncodingException;
import io.joynr.smrf.MessageDeserializer;
import io.joynr.smrf.MessageDeserializerImpl;
import io.joynr.smrf.UnsuppportedVersionException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import joynr.Message;

public class ImmutableMessage
extends Message {
    private transient boolean receivedFromGlobal;
    private final MessageDeserializer messageDeserializer;
    private final byte[] serializedMessage;
    private transient Map<String, Serializable> context = new HashMap<String, Serializable>();

    public ImmutableMessage(byte[] serializedMessage) throws EncodingException, UnsuppportedVersionException {
        this.serializedMessage = (byte[])serializedMessage.clone();
        this.messageDeserializer = new MessageDeserializerImpl(this.serializedMessage);
    }

    public byte[] getSerializedMessage() {
        return (byte[])this.serializedMessage.clone();
    }

    public long getTtlMs() {
        return this.messageDeserializer.getTtlMs();
    }

    public boolean isTtlAbsolute() {
        return this.messageDeserializer.isTtlAbsolute();
    }

    public String getSender() {
        return this.messageDeserializer.getSender();
    }

    public String getRecipient() {
        return this.messageDeserializer.getRecipient();
    }

    public String getReplyTo() {
        return this.messageDeserializer.getHeader("re");
    }

    public String getType() {
        return this.messageDeserializer.getHeader("t");
    }

    public String toLogMessage() {
        return "";
    }

    public String getEffort() {
        return this.messageDeserializer.getHeader("ef");
    }

    public String getCreatorUserId() {
        return System.getProperty("user.name");
    }

    public byte[] getUnencryptedBody() throws EncodingException {
        return this.messageDeserializer.getUnencryptedBody();
    }

    public Map<String, String> getHeaders() {
        return this.messageDeserializer.getHeaders();
    }

    public Map<String, String> getCustomHeaders() {
        HashMap<String, String> customHeaders = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.getHeaders().entrySet()) {
            if (!entry.getKey().startsWith("c-")) continue;
            String key = entry.getKey().replaceFirst("^c-", "");
            customHeaders.put(key, entry.getValue());
        }
        return customHeaders;
    }

    public void setContext(HashMap<String, Serializable> context) {
        this.context = context;
    }

    public Map<String, Serializable> getContext() {
        return this.context;
    }

    public void setReceivedFromGlobal(boolean receivedFromGlobal) {
        this.receivedFromGlobal = receivedFromGlobal;
    }

    public boolean isReceivedFromGlobal() {
        return this.receivedFromGlobal;
    }

    public String getId() {
        return this.messageDeserializer.getHeader("id");
    }

    public boolean isEncrypted() {
        return this.messageDeserializer.isEncrypted();
    }

    public boolean isSigned() {
        return this.messageDeserializer.isSigned();
    }

    public int getMessageSize() {
        return this.messageDeserializer.getMessageSize();
    }
}

