/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.routing;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.joynr.exceptions.JoynrIllegalStateException;
import io.joynr.exceptions.JoynrMessageNotSentException;
import io.joynr.exceptions.JoynrRuntimeException;
import io.joynr.messaging.routing.MulticastAddressCalculator;
import io.joynr.messaging.routing.MulticastReceiverRegistry;
import io.joynr.messaging.routing.RoutingTable;
import java.util.HashSet;
import java.util.Set;
import joynr.ImmutableMessage;
import joynr.system.RoutingTypes.Address;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressManager {
    private static final Logger logger = LoggerFactory.getLogger(AddressManager.class);
    private final MulticastReceiverRegistry multicastReceiversRegistry;
    private RoutingTable routingTable;
    private MulticastAddressCalculator multicastAddressCalculator;

    @Inject
    public AddressManager(RoutingTable routingTable, PrimaryGlobalTransportHolder primaryGlobalTransport, Set<MulticastAddressCalculator> multicastAddressCalculators, MulticastReceiverRegistry multicastReceiverRegistry) {
        logger.trace("Initialised with routingTable: {} primaryGlobalTransport: {} multicastAddressCalculators: {} multicastReceiverRegistry: {}", new Object[]{routingTable, primaryGlobalTransport.get(), multicastAddressCalculators, multicastReceiverRegistry});
        this.routingTable = routingTable;
        this.multicastReceiversRegistry = multicastReceiverRegistry;
        if (multicastAddressCalculators.size() > 1 && primaryGlobalTransport.get() == null) {
            throw new JoynrIllegalStateException("Multiple multicast address calculators registered, but no primary global transport set.");
        }
        if (multicastAddressCalculators.size() == 1) {
            this.multicastAddressCalculator = multicastAddressCalculators.iterator().next();
        } else {
            for (MulticastAddressCalculator multicastAddressCalculator : multicastAddressCalculators) {
                if (!multicastAddressCalculator.supports(primaryGlobalTransport.get())) continue;
                this.multicastAddressCalculator = multicastAddressCalculator;
                break;
            }
        }
    }

    public Set<Address> getAddresses(ImmutableMessage message) {
        Address address;
        HashSet<Address> result = new HashSet<Address>();
        String toParticipantId = message.getRecipient();
        if ("m".equals(message.getType())) {
            this.handleMulticastMessage(message, result);
        } else if (toParticipantId != null && this.routingTable.containsKey(toParticipantId) && (address = this.routingTable.get(toParticipantId)) != null) {
            result.add(address);
        }
        logger.trace("Found the following addresses for {}: {}", new Object[]{message, result});
        if (result.size() == 0) {
            if ("m".equals(message.getType())) {
                throw new JoynrMessageNotSentException("Failed to send Request: No address for given message: " + message);
            }
            throw new JoynrIllegalStateException("Unable to find address for participant with ID " + toParticipantId);
        }
        return result;
    }

    private void handleMulticastMessage(ImmutableMessage message, Set<Address> result) {
        if (!message.isReceivedFromGlobal() && this.multicastAddressCalculator != null) {
            Address calculatedAddress;
            String participantId = message.getSender();
            boolean isGloballyVisible = false;
            try {
                isGloballyVisible = this.routingTable.getIsGloballyVisible(participantId);
            }
            catch (JoynrRuntimeException e) {
                logger.error("No routing entry found for Mulicast Provider {}. The message will not be published globally.", (Object)participantId);
            }
            if (isGloballyVisible && (calculatedAddress = this.multicastAddressCalculator.calculate(message)) != null) {
                result.add(calculatedAddress);
            }
        }
        Set<String> receivers = this.multicastReceiversRegistry.getReceivers(message.getRecipient());
        for (String receiverParticipantId : receivers) {
            Address address = this.routingTable.get(receiverParticipantId);
            if (address == null) continue;
            result.add(address);
        }
    }

    protected static class PrimaryGlobalTransportHolder {
        @Inject(optional=true)
        @Named(value="joynr.messaging.primaryglobaltransport")
        private String primaryGlobalTransport;

        public PrimaryGlobalTransportHolder() {
        }

        protected PrimaryGlobalTransportHolder(String primaryGlobalTransport) {
            this.primaryGlobalTransport = primaryGlobalTransport;
        }

        public String get() {
            return this.primaryGlobalTransport;
        }
    }
}

