/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.routing;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.joynr.messaging.routing.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.locks.Condition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoundedDelayQueue<E extends Delayed>
extends DelayQueue<E> {
    private Logger logger = LoggerFactory.getLogger(BoundedDelayQueue.class);
    final int maxElementCount;
    private final Condition spaceAvailable = this.lock.newCondition();

    @Inject
    public BoundedDelayQueue(@Named(value="joynr.messaging.maxmessagesinqueue") int maxElements) {
        this.maxElementCount = maxElements;
    }

    public void putBounded(E delayable) throws InterruptedException {
        try {
            this.logger.trace("acquiring lock");
            this.lock.lockInterruptibly();
            while (this.q.size() == this.maxElementCount) {
                this.logger.trace("waiting for space");
                this.spaceAvailable.await();
            }
            this.logger.trace("putting element");
            super.put(delayable);
        }
        finally {
            this.logger.trace("finished");
            this.lock.unlock();
        }
    }

    @Override
    public E take() throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            Object delayable = super.take();
            this.spaceAvailable.signal();
            Object object = delayable;
            return (E)object;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.q.isEmpty();
    }
}

