/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.runtime;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import io.joynr.messaging.routing.GlobalAddressFactory;
import io.joynr.messaging.routing.TransportReadyListener;
import java.util.Set;
import joynr.system.RoutingTypes.Address;

public class ReplyToAddressProvider
implements Provider<Address> {
    public static final String REPLY_TO_ADDRESS_PROVIDER = "reply_to_address_provider";
    private Set<GlobalAddressFactory<? extends Address>> replyToAddressFactories;
    @Inject(optional=true)
    @Named(value="joynr.messaging.primaryglobaltransport")
    String primaryGlobalTransport;

    @Inject
    public ReplyToAddressProvider(@Named(value="reply_to_address_provider") Set<GlobalAddressFactory<? extends Address>> addressFactories) {
        this.replyToAddressFactories = addressFactories;
    }

    public void registerGlobalAddressesReadyListener(TransportReadyListener listener) {
        GlobalAddressFactory<? extends Address> addressFactory = this.getPrimaryReplyToAddressFactory();
        addressFactory.registerGlobalAddressReady(listener);
    }

    public GlobalAddressFactory<? extends Address> getAddressFactoryForTransport(String transport) {
        for (GlobalAddressFactory<? extends Address> addressFactory : this.replyToAddressFactories) {
            if (!addressFactory.supportsTransport(transport)) continue;
            return addressFactory;
        }
        return null;
    }

    public GlobalAddressFactory<? extends Address> getAddressFactoryByClass(Class<GlobalAddressFactory<? extends Address>> targetAddressFactoryClass) {
        if (targetAddressFactoryClass == null) {
            return null;
        }
        for (GlobalAddressFactory<? extends Address> addressFactory : this.replyToAddressFactories) {
            if (!addressFactory.getClass().isAssignableFrom(targetAddressFactoryClass)) continue;
            return addressFactory;
        }
        return null;
    }

    public Address get() {
        try {
            GlobalAddressFactory<? extends Address> addressFactory = this.getPrimaryReplyToAddressFactory();
            return addressFactory.create();
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    private GlobalAddressFactory<? extends Address> getPrimaryReplyToAddressFactory() {
        GlobalAddressFactory<? extends Address> addressFactory = this.getAddressFactoryForTransport(this.primaryGlobalTransport);
        if (addressFactory == null) {
            if (this.replyToAddressFactories.size() == 1) {
                addressFactory = this.replyToAddressFactories.iterator().next();
            } else {
                if (this.replyToAddressFactories.size() == 0) {
                    throw new IllegalStateException("no global transport was registered");
                }
                if (this.replyToAddressFactories.size() > 1) {
                    throw new IllegalStateException("multiple global transports were registered but joynr.messaging.primaryglobaltransport was not set.");
                }
            }
        }
        return addressFactory;
    }
}

