/*
 * Decompiled with CFR 0.152.
 */
package joynr;

import com.google.common.collect.Maps;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.joynr.smrf.EncodingException;
import io.joynr.smrf.MessageSerializerImpl;
import io.joynr.smrf.UnsuppportedVersionException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import joynr.ImmutableMessage;
import joynr.Message;

public class MutableMessage
extends Message {
    private String sender;
    private String recipient;
    private long ttlMs;
    private boolean ttlAbsolute;
    private byte[] payload;
    private String id;
    private String type;
    private String replyTo;
    private String effort;
    private Map<String, String> customHeaders = Maps.newHashMap();
    private transient boolean compressed = false;

    public MutableMessage() {
        this.id = UUID.randomUUID().toString();
    }

    public ImmutableMessage getImmutableMessage() throws SecurityException, EncodingException, UnsuppportedVersionException {
        MessageSerializerImpl messageSerializer = new MessageSerializerImpl();
        messageSerializer.setSender(this.getSender());
        messageSerializer.setRecipient(this.getRecipient());
        messageSerializer.setTtlMs(this.getTtlMs());
        messageSerializer.setTtlAbsolute(this.isTtlAbsolute());
        messageSerializer.setHeaders(this.createHeader());
        messageSerializer.setBody(this.getPayload());
        messageSerializer.setCompressed(this.compressed);
        return new ImmutableMessage(messageSerializer.serialize());
    }

    private Map<String, String> createHeader() {
        HashMap header = Maps.newHashMap();
        if (this.customHeaders != null && !this.customHeaders.isEmpty()) {
            for (Map.Entry<String, String> entry : this.customHeaders.entrySet()) {
                header.put("c-" + entry.getKey(), entry.getValue());
            }
        }
        this.putIfValueNotNull("t", this.type, header);
        this.putIfValueNotNull("id", this.id, header);
        this.putIfValueNotNull("re", this.replyTo, header);
        this.putIfValueNotNull("ef", this.effort, header);
        return header;
    }

    private void putIfValueNotNull(String key, String value, Map<String, String> destination) {
        if (value != null) {
            destination.put(key, value);
        }
    }

    public String getSender() {
        return this.sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    public long getTtlMs() {
        return this.ttlMs;
    }

    public void setTtlMs(long ttlMs) {
        this.ttlMs = ttlMs;
    }

    public boolean isTtlAbsolute() {
        return this.ttlAbsolute;
    }

    public void setTtlAbsolute(boolean ttlAbsolute) {
        this.ttlAbsolute = ttlAbsolute;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public byte[] getPayload() {
        return this.payload;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public void setPayload(byte[] payload) {
        this.payload = payload;
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
    }

    public String getEffort() {
        return this.effort;
    }

    public void setEffort(String effort) {
        this.effort = effort;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.putAll(customHeaders);
    }

    public void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }

    public boolean getCompressed() {
        return this.compressed;
    }
}

