/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.routing;

import io.joynr.messaging.routing.DelayableImmutableMessage;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class TimedDelayed
implements Delayed {
    static final AtomicLong sequencer = new AtomicLong();
    protected long delayUntilDate;
    protected long sequenceNumber;

    public TimedDelayed() {
    }

    public TimedDelayed(long delayForMs) {
        this.delayUntilDate = System.currentTimeMillis() + delayForMs;
        this.sequenceNumber = sequencer.getAndIncrement();
    }

    @Override
    public int compareTo(Delayed other) {
        if (other == this) {
            return 0;
        }
        if (other instanceof DelayableImmutableMessage) {
            DelayableImmutableMessage otherDelayedMessage = (DelayableImmutableMessage)other;
            long diffDelayedUntil = this.delayUntilDate - otherDelayedMessage.delayUntilDate;
            if (diffDelayedUntil < 0L) {
                return -1;
            }
            if (diffDelayedUntil > 0L) {
                return 1;
            }
            if (this.sequenceNumber < otherDelayedMessage.sequenceNumber) {
                return -1;
            }
            return 1;
        }
        long diff = this.getDelay(TimeUnit.NANOSECONDS) - other.getDelay(TimeUnit.NANOSECONDS);
        return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
    }

    @Override
    public long getDelay(TimeUnit unit) {
        long diff = this.delayUntilDate - System.currentTimeMillis();
        return unit.convert(diff, TimeUnit.MILLISECONDS);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.delayUntilDate ^ this.delayUntilDate >>> 32);
        result = 31 * result + (int)(this.sequenceNumber ^ this.sequenceNumber >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimedDelayed other = (TimedDelayed)obj;
        if (this.delayUntilDate != other.delayUntilDate) {
            return false;
        }
        return this.sequenceNumber == other.sequenceNumber;
    }
}

