/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.routing;

import io.joynr.messaging.routing.MessageRouter;
import io.joynr.messaging.routing.TransportReadyListener;
import io.joynr.provider.AbstractDeferred;
import io.joynr.provider.Deferred;
import io.joynr.provider.DeferredVoid;
import io.joynr.provider.Promise;
import io.joynr.runtime.GlobalAddressProvider;
import io.joynr.runtime.ReplyToAddressProvider;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import joynr.system.RoutingAbstractProvider;
import joynr.system.RoutingProvider;
import joynr.system.RoutingTypes.Address;
import joynr.system.RoutingTypes.BrowserAddress;
import joynr.system.RoutingTypes.ChannelAddress;
import joynr.system.RoutingTypes.CommonApiDbusAddress;
import joynr.system.RoutingTypes.MqttAddress;
import joynr.system.RoutingTypes.RoutingTypesUtil;
import joynr.system.RoutingTypes.WebSocketAddress;
import joynr.system.RoutingTypes.WebSocketClientAddress;

public class RoutingProviderImpl
extends RoutingAbstractProvider {
    private MessageRouter messageRouter;
    private String globalAddressString;
    private String replyToAddressString;
    private List<Deferred<String>> unresolvedGlobalAddressDeferreds = new ArrayList<Deferred<String>>();
    private List<Deferred<String>> unresolvedReplyToAddressDeferreds = new ArrayList<Deferred<String>>();

    @Inject
    public RoutingProviderImpl(MessageRouter messageRouter, GlobalAddressProvider globalAddressProvider, ReplyToAddressProvider replyToAddressProvider) {
        this.messageRouter = messageRouter;
        globalAddressProvider.registerGlobalAddressesReadyListener(new TransportReadyListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void transportReady(Address address) {
                List list = RoutingProviderImpl.this.unresolvedGlobalAddressDeferreds;
                synchronized (list) {
                    RoutingProviderImpl.this.globalAddressString = RoutingTypesUtil.toAddressString((Address)address);
                    for (Deferred globalAddressDeferred : RoutingProviderImpl.this.unresolvedGlobalAddressDeferreds) {
                        globalAddressDeferred.resolve((Object)RoutingProviderImpl.this.globalAddressString);
                    }
                    RoutingProviderImpl.this.unresolvedGlobalAddressDeferreds.clear();
                    RoutingProviderImpl.this.globalAddressChanged(RoutingProviderImpl.this.globalAddressString);
                }
            }
        });
        replyToAddressProvider.registerGlobalAddressesReadyListener(new TransportReadyListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void transportReady(Address address) {
                List list = RoutingProviderImpl.this.unresolvedReplyToAddressDeferreds;
                synchronized (list) {
                    RoutingProviderImpl.this.replyToAddressString = RoutingTypesUtil.toAddressString((Address)address);
                    for (Deferred replyToAddressDeferred : RoutingProviderImpl.this.unresolvedReplyToAddressDeferreds) {
                        replyToAddressDeferred.resolve((Object)RoutingProviderImpl.this.replyToAddressString);
                    }
                    RoutingProviderImpl.this.unresolvedReplyToAddressDeferreds.clear();
                    RoutingProviderImpl.this.replyToAddressChanged(RoutingProviderImpl.this.replyToAddressString);
                }
            }
        });
    }

    private Promise<DeferredVoid> resolvedDeferred() {
        DeferredVoid deferred = new DeferredVoid();
        deferred.resolve();
        return new Promise((AbstractDeferred)deferred);
    }

    public Promise<DeferredVoid> addNextHop(String participantId, ChannelAddress address, Boolean isGloballyVisible) {
        this.messageRouter.addNextHop(participantId, (Address)address, isGloballyVisible);
        return this.resolvedDeferred();
    }

    public Promise<DeferredVoid> addNextHop(String participantId, MqttAddress address, Boolean isGloballyVisible) {
        this.messageRouter.addNextHop(participantId, (Address)address, isGloballyVisible);
        return this.resolvedDeferred();
    }

    public Promise<DeferredVoid> addNextHop(String participantId, CommonApiDbusAddress address, Boolean isGloballyVisible) {
        this.messageRouter.addNextHop(participantId, (Address)address, isGloballyVisible);
        return this.resolvedDeferred();
    }

    public Promise<DeferredVoid> addNextHop(String participantId, BrowserAddress address, Boolean isGloballyVisible) {
        this.messageRouter.addNextHop(participantId, (Address)address, isGloballyVisible);
        return this.resolvedDeferred();
    }

    public Promise<DeferredVoid> addNextHop(String participantId, WebSocketAddress address, Boolean isGloballyVisible) {
        this.messageRouter.addNextHop(participantId, (Address)address, isGloballyVisible);
        return this.resolvedDeferred();
    }

    public Promise<DeferredVoid> addNextHop(String participantId, WebSocketClientAddress address, Boolean isGloballyVisible) {
        this.messageRouter.addNextHop(participantId, (Address)address, isGloballyVisible);
        return this.resolvedDeferred();
    }

    public Promise<DeferredVoid> removeNextHop(String participantId) {
        this.messageRouter.removeNextHop(participantId);
        return this.resolvedDeferred();
    }

    public Promise<RoutingProvider.ResolveNextHopDeferred> resolveNextHop(String participantId) {
        boolean resolved = this.messageRouter.resolveNextHop(participantId);
        RoutingProvider.ResolveNextHopDeferred deferred = new RoutingProvider.ResolveNextHopDeferred();
        deferred.resolve(Boolean.valueOf(resolved));
        return new Promise((AbstractDeferred)deferred);
    }

    public Promise<DeferredVoid> addMulticastReceiver(String multicastId, String subscriberParticipantId, String providerParticipantId) {
        this.messageRouter.addMulticastReceiver(multicastId, subscriberParticipantId, providerParticipantId);
        return this.resolvedDeferred();
    }

    public Promise<DeferredVoid> removeMulticastReceiver(String multicastId, String subscriberParticipantId, String providerParticipantId) {
        this.messageRouter.removeMulticastReceiver(multicastId, subscriberParticipantId, providerParticipantId);
        return this.resolvedDeferred();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Promise<Deferred<String>> getGlobalAddress() {
        Deferred globalAddressDeferred = new Deferred();
        List<Deferred<String>> list = this.unresolvedGlobalAddressDeferreds;
        synchronized (list) {
            if (this.globalAddressString != null) {
                globalAddressDeferred.resolve((Object)this.globalAddressString);
            } else {
                this.unresolvedGlobalAddressDeferreds.add((Deferred<String>)globalAddressDeferred);
            }
        }
        return new Promise((AbstractDeferred)globalAddressDeferred);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Promise<Deferred<String>> getReplyToAddress() {
        Deferred replyToAddressDeferred = new Deferred();
        List<Deferred<String>> list = this.unresolvedReplyToAddressDeferreds;
        synchronized (list) {
            if (this.replyToAddressString != null) {
                replyToAddressDeferred.resolve((Object)this.replyToAddressString);
            } else {
                this.unresolvedReplyToAddressDeferreds.add((Deferred<String>)replyToAddressDeferred);
            }
        }
        return new Promise((AbstractDeferred)replyToAddressDeferred);
    }
}

