/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging;

import io.joynr.messaging.IMessageReceivers;
import io.joynr.messaging.MessageReceiver;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageReceivers
implements IMessageReceivers {
    private static final Logger log = LoggerFactory.getLogger(MessageReceivers.class);
    ConcurrentHashMap<String, MessageReceiver> messageReceivers = new ConcurrentHashMap();

    @Override
    @Nullable
    public MessageReceiver getReceiverForChannelId(String channelId) {
        return this.messageReceivers.get(channelId);
    }

    @Override
    public void registerMessageReceiver(MessageReceiver messageReceiver, String channelId) {
        log.debug("Message Receiver registered for: " + channelId);
        this.messageReceivers.put(channelId, messageReceiver);
    }

    @Override
    public Collection<MessageReceiver> getAllMessageReceivers() {
        return this.messageReceivers.values();
    }

    @Override
    public boolean contains(String channelId) {
        return this.messageReceivers.containsKey(channelId);
    }
}

