/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.util;

import com.google.common.collect.Lists;
import java.util.List;

public class Utilities {
    public static Object[] toArray(Object ... args) {
        return args;
    }

    public static List<String> splitJson(String combinedJsonString) {
        List result = Lists.newArrayList();
        int numberOfOpeningBraces = 0;
        boolean isInsideString = false;
        StringBuilder jsonBuffer = new StringBuilder();
        int i = 0;
        while (i < combinedJsonString.length()) {
            char c = combinedJsonString.charAt(i);
            if (c == '\"' && i > 0 && combinedJsonString.charAt(i - 1) != '\\') {
                boolean bl = isInsideString = !isInsideString;
            }
            if (c == '{' && !isInsideString) {
                ++numberOfOpeningBraces;
            } else if (c == '}' && !isInsideString) {
                --numberOfOpeningBraces;
            }
            jsonBuffer.append(c);
            if (numberOfOpeningBraces == 0 && jsonBuffer.length() != 0) {
                if (jsonBuffer.toString().charAt(0) == '{') {
                    result.add(jsonBuffer.toString());
                }
                jsonBuffer.setLength(0);
            }
            ++i;
        }
        return result;
    }

    public static boolean isSessionEncodedInUrl(String encodedUrl, String sessionIdName) {
        int sessionIdIndex = encodedUrl.indexOf(Utilities.getSessionIdSubstring(sessionIdName));
        return sessionIdIndex >= 0;
    }

    public static String getUrlWithoutJsessionId(String url, String sessionIdName) {
        if (Utilities.isSessionEncodedInUrl(url, sessionIdName)) {
            return url.substring(0, url.indexOf(Utilities.getSessionIdSubstring(sessionIdName)));
        }
        return url;
    }

    public static String getSessionId(String url, String sessionIdName) {
        String sessionIdSubstring = Utilities.getSessionIdSubstring(sessionIdName);
        String sessionId = url.substring(url.indexOf(sessionIdSubstring) + sessionIdSubstring.length());
        if (sessionId.endsWith("/")) {
            sessionId = sessionId.substring(0, sessionId.length() - 1);
        }
        return sessionId;
    }

    private static String getSessionIdSubstring(String sessionIdName) {
        return ";" + sessionIdName + "=";
    }

    public static String getSessionEncodedUrl(String url, String sessionIdName, String sessionId) {
        return String.valueOf(url) + Utilities.getSessionIdSubstring(sessionIdName) + sessionId;
    }
}

