/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.runtime;

import io.joynr.guice.LowerCaseProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyLoader {
    private static Logger logger = LoggerFactory.getLogger(PropertyLoader.class);

    @CheckForNull
    public static InputStream loadResource(String resourceName) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL url = classLoader.getResource(resourceName);
        if (url != null) {
            InputStream urlStream = null;
            try {
                urlStream = url.openStream();
                return urlStream;
            }
            catch (IOException iOException) {}
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(resourceName);
            return fileInputStream;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static Properties loadProperties(String fileName) {
        LowerCaseProperties properties;
        block15: {
            properties = new LowerCaseProperties();
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            URL url = classLoader.getResource(fileName);
            if (url != null) {
                InputStream urlStream = null;
                try {
                    try {
                        urlStream = url.openStream();
                        properties.load(urlStream);
                        logger.info("Properties from classpath loaded file: " + fileName);
                    }
                    catch (IOException iOException) {
                        logger.info("Properties from classpath not loaded because file not found: " + fileName);
                        if (urlStream != null) {
                            try {
                                urlStream.close();
                            }
                            catch (IOException iOException2) {}
                        }
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    if (urlStream != null) {
                        try {
                            urlStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (urlStream != null) {
                    try {
                        urlStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        LowerCaseProperties propertiesFromFileSystem = PropertyLoader.loadProperties(new File(fileName));
        properties.putAll((Map)propertiesFromFileSystem);
        return properties;
    }

    public static LowerCaseProperties loadProperties(File file) {
        LowerCaseProperties properties;
        block14: {
            properties = new LowerCaseProperties();
            FileInputStream fileInputStream = null;
            try {
                try {
                    fileInputStream = new FileInputStream(file);
                    properties.load((InputStream)fileInputStream);
                    logger.info("Properties from runtime directory loaded file: " + file.getAbsolutePath());
                }
                catch (IOException e) {
                    logger.info("Properties from runtime directory not loaded because: " + e.getMessage());
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return properties;
    }

    public static Properties loadProperties(Properties properties, String fileName) {
        properties.putAll((Map<?, ?>)PropertyLoader.loadProperties(fileName));
        return properties;
    }

    public static Properties getPropertiesWithPattern(Properties originalProperties, String regex) {
        Properties properties = new Properties();
        Enumeration<Object> keys = originalProperties.keys();
        while (keys.hasMoreElements()) {
            String nextKey = (String)keys.nextElement();
            if (!Pattern.compile(regex).matcher(nextKey).find()) continue;
            properties.put(nextKey, originalProperties.getProperty(nextKey));
        }
        return properties;
    }
}

