/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.SimpleType;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import io.joynr.messaging.serialize.JoynrEnumSerializer;
import io.joynr.messaging.serialize.JoynrListSerializer;
import io.joynr.messaging.serialize.JoynrUntypedObjectDeserializer;
import io.joynr.messaging.serialize.NumberSerializer;
import io.joynr.security.DummyPlatformSecurityManager;
import io.joynr.security.PlatformSecurityManager;

public class MessagingModule
extends AbstractModule {
    private ObjectMapper objectMapper = new ObjectMapper();

    public MessagingModule() {
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.objectMapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
        this.objectMapper.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, true);
        this.objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        this.objectMapper.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
        this.objectMapper.enableDefaultTypingAsProperty(ObjectMapper.DefaultTyping.JAVA_LANG_OBJECT, "_typeName");
        TypeResolverBuilder joynrTypeResolverBuilder = this.objectMapper.getSerializationConfig().getDefaultTyper((JavaType)SimpleType.construct(Object.class));
        SimpleModule module = new SimpleModule("NonTypedModule", new Version(1, 0, 0, "", "", ""));
        module.addSerializer(Number.class, (JsonSerializer)new NumberSerializer());
        module.addSerializer((JsonSerializer)new JoynrEnumSerializer());
        module.addSerializer((JsonSerializer)new JoynrListSerializer());
        TypeDeserializer typeDeserializer = joynrTypeResolverBuilder.buildTypeDeserializer(this.objectMapper.getDeserializationConfig(), (JavaType)SimpleType.construct(Object.class), null);
        module.addDeserializer(Object.class, (JsonDeserializer)new JoynrUntypedObjectDeserializer(typeDeserializer));
        module.setMixInAnnotation(Throwable.class, ThrowableMixIn.class);
        this.objectMapper.registerModule((Module)module);
    }

    protected void configure() {
        this.bind(PlatformSecurityManager.class).to(DummyPlatformSecurityManager.class);
    }

    @Provides
    @Singleton
    ObjectMapper provideObjectMapper() {
        return this.objectMapper;
    }

    public abstract class ThrowableMixIn {
        @JsonProperty
        private String detailMessage;
    }
}

