/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.routing;

import com.google.common.collect.Maps;
import com.google.inject.Singleton;
import io.joynr.exceptions.JoynrRuntimeException;
import io.joynr.messaging.routing.AddressOperation;
import io.joynr.messaging.routing.RoutingTable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import joynr.system.RoutingTypes.Address;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RoutingTableImpl
implements RoutingTable {
    private static final Logger logger = LoggerFactory.getLogger(RoutingTableImpl.class);
    private ConcurrentMap<String, RoutingEntry> hashMap = Maps.newConcurrentMap();

    @Override
    public Address get(String participantId) {
        logger.trace("entering get(participantId={})", (Object)participantId);
        this.dumpRoutingTableEntry();
        RoutingEntry routingEntry = (RoutingEntry)this.hashMap.get(participantId);
        if (routingEntry == null) {
            return null;
        }
        logger.trace("leaving get(participantId={}) = {}", (Object)routingEntry.getAddress());
        return routingEntry.getAddress();
    }

    private void dumpRoutingTableEntry() {
        if (logger.isTraceEnabled()) {
            StringBuilder message = new StringBuilder("Routing table entries:\n");
            for (Map.Entry eachEntry : this.hashMap.entrySet()) {
                message.append("\t> ").append((String)eachEntry.getKey()).append("\t-\t").append(((RoutingEntry)eachEntry.getValue()).address).append("\t-\t").append(((RoutingEntry)eachEntry.getValue()).isGloballyVisible).append("\t-\t").append(((RoutingEntry)eachEntry.getValue()).expiryDateMs).append("\t-\t").append(((RoutingEntry)eachEntry.getValue()).isSticky).append("\n");
            }
            logger.trace(message.toString());
        }
    }

    @Override
    public void put(String participantId, Address address, boolean isGloballyVisible, long expiryDateMs, boolean sticky, boolean allowUpdate) {
        boolean routingEntryChanged;
        boolean routingEntryAlreadyPresent;
        RoutingEntry routingEntry = new RoutingEntry(address, isGloballyVisible, expiryDateMs, sticky);
        RoutingEntry result = this.hashMap.putIfAbsent(participantId, routingEntry);
        boolean bl = routingEntryAlreadyPresent = result != null;
        if (!routingEntryAlreadyPresent) {
            logger.trace("put(participantId={}, address={}, isGloballyVisible={}, expiryDateMs={}, sticky={}) successfully into routing table", new Object[]{participantId, address, isGloballyVisible, expiryDateMs, sticky});
            return;
        }
        boolean bl2 = routingEntryChanged = !address.equals((Object)result.getAddress()) || result.getIsGloballyVisible() != isGloballyVisible;
        if (routingEntryChanged) {
            if (allowUpdate) {
                logger.debug("put(participantId={}, address={}, isGloballyVisible={}, expiryDateMs={}, sticky={}). Replacing previous entry with address={}, isGloballyVisible={}, expiryDateMs={}, sticky={}", new Object[]{participantId, address, isGloballyVisible, expiryDateMs, sticky, result.address, result.isGloballyVisible, result.expiryDateMs, result.isSticky});
                this.mergeRoutingEntryAttributes(routingEntry, result.getExpiryDateMs(), result.getIsSticky());
                this.hashMap.put(participantId, routingEntry);
            } else {
                logger.warn("unable to update(participantId={}, address={}, isGloballyVisible={}, expiryDateMs={}, sticky={}) into routing table, since the participant ID is already associated with routing entry address={}, isGloballyVisible={}", new Object[]{participantId, address, isGloballyVisible, expiryDateMs, sticky, result.address, result.isGloballyVisible});
            }
        } else {
            logger.trace("put(participantId={}, address={}, isGloballyVisible={}, expiryDateMs={}, sticky={}): Entry exists. Updating expiryDate and sticky-flag", new Object[]{participantId, address, isGloballyVisible, expiryDateMs, sticky});
            this.mergeRoutingEntryAttributes(result, expiryDateMs, sticky);
        }
    }

    private void mergeRoutingEntryAttributes(RoutingEntry entry, long expiryDateMs, boolean isSticky) {
        if (entry.getExpiryDateMs() < expiryDateMs) {
            entry.setExpiryDateMs(expiryDateMs);
        }
        if (isSticky && !entry.getIsSticky()) {
            entry.setIsSticky(true);
        }
    }

    @Override
    public boolean containsKey(String participantId) {
        boolean containsKey = this.hashMap.containsKey(participantId);
        logger.trace("checking for participant: {} success: {}", (Object)participantId, (Object)containsKey);
        if (!containsKey) {
            this.dumpRoutingTableEntry();
        }
        return containsKey;
    }

    @Override
    public boolean getIsGloballyVisible(String participantId) {
        RoutingEntry routingEntry = (RoutingEntry)this.hashMap.get(participantId);
        if (routingEntry == null) {
            throw new JoynrRuntimeException("participantId doesn't exist in the routing table");
        }
        return routingEntry.getIsGloballyVisible();
    }

    @Override
    public void setIsSticky(String participantId, boolean isSticky) {
        RoutingEntry routingEntry = (RoutingEntry)this.hashMap.get(participantId);
        if (routingEntry == null) {
            throw new JoynrRuntimeException("participantId doesn't exist in the routing table");
        }
        routingEntry.setIsSticky(isSticky);
    }

    @Override
    public long getExpiryDateMs(String participantId) {
        RoutingEntry routingEntry = (RoutingEntry)this.hashMap.get(participantId);
        if (routingEntry == null) {
            throw new JoynrRuntimeException("participantId doesn't exist in the routing table");
        }
        return routingEntry.getExpiryDateMs();
    }

    @Override
    public boolean getIsSticky(String participantId) {
        RoutingEntry routingEntry = (RoutingEntry)this.hashMap.get(participantId);
        if (routingEntry == null) {
            throw new JoynrRuntimeException("participantId doesn't exist in the routing table");
        }
        return routingEntry.getIsSticky();
    }

    @Override
    public void remove(String participantId) {
        RoutingEntry routingEntry = (RoutingEntry)this.hashMap.get(participantId);
        if (routingEntry != null) {
            logger.trace("removing(participantId={}, address={}, isGloballyVisible={}, expiryDateMs={}, sticky={}) from routing table", new Object[]{participantId, routingEntry.getAddress(), routingEntry.getIsGloballyVisible(), routingEntry.getExpiryDateMs(), routingEntry.getIsSticky()});
        }
        this.hashMap.remove(participantId);
    }

    @Override
    public void apply(AddressOperation addressOperation) {
        if (addressOperation == null) {
            throw new IllegalArgumentException();
        }
        for (RoutingEntry routingEntry : this.hashMap.values()) {
            addressOperation.perform(routingEntry.getAddress());
        }
    }

    @Override
    public void purge() {
        logger.trace("purge: begin");
        Iterator it = this.hashMap.entrySet().iterator();
        long currentTimeMillis = System.currentTimeMillis();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            if (logger.isTraceEnabled()) {
                logger.trace("check: participantId = {}, sticky = {}, expiryDateMs = {}, now = {}", new Object[]{e.getKey(), ((RoutingEntry)e.getValue()).getIsSticky(), ((RoutingEntry)e.getValue()).getExpiryDateMs(), currentTimeMillis});
            }
            if (((RoutingEntry)e.getValue()).getIsSticky() || ((RoutingEntry)e.getValue()).expiryDateMs >= currentTimeMillis) continue;
            if (logger.isTraceEnabled()) {
                logger.trace("purging(participantId={}, address={}, isGloballyVisible={}, expiryDateMs={}, sticky={}) from routing table", new Object[]{e.getKey(), ((RoutingEntry)e.getValue()).getAddress(), ((RoutingEntry)e.getValue()).getIsGloballyVisible(), ((RoutingEntry)e.getValue()).getExpiryDateMs(), ((RoutingEntry)e.getValue()).getIsSticky()});
            }
            it.remove();
        }
        logger.trace("purge: end");
    }

    private static class RoutingEntry {
        private Address address;
        private boolean isGloballyVisible;
        private long expiryDateMs;
        private boolean isSticky;

        RoutingEntry(Address address, boolean isGloballyVisible, long expiryDateMs, boolean isSticky) {
            this.setAddress(address);
            this.setIsGloballyVisible(isGloballyVisible);
            this.expiryDateMs = expiryDateMs;
            this.isSticky = isSticky;
        }

        public Address getAddress() {
            return this.address;
        }

        public boolean getIsGloballyVisible() {
            return this.isGloballyVisible;
        }

        public long getExpiryDateMs() {
            return this.expiryDateMs;
        }

        public boolean getIsSticky() {
            return this.isSticky;
        }

        public void setAddress(Address address) {
            this.address = address;
        }

        public void setIsGloballyVisible(boolean isGloballyVisible) {
            this.isGloballyVisible = isGloballyVisible;
        }

        public void setExpiryDateMs(long expiryDateMs) {
            this.expiryDateMs = expiryDateMs;
        }

        public void setIsSticky(boolean isSticky) {
            this.isSticky = isSticky;
        }
    }
}

