/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.runtime;

import com.google.inject.Singleton;
import io.joynr.runtime.ShutdownListener;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ShutdownNotifier {
    private static final Logger logger = LoggerFactory.getLogger(ShutdownNotifier.class);
    List<ShutdownListener> shutdownListeners = new LinkedList<ShutdownListener>();

    public void registerForShutdown(ShutdownListener shutdownListener) {
        this.shutdownListeners.add(shutdownListener);
    }

    public void shutdown() {
        for (ShutdownListener shutdownListener : this.shutdownListeners) {
            try {
                shutdownListener.shutdown();
            }
            catch (Exception e) {
                logger.error("error shutting down {}: {}", (Object)shutdownListener, (Object)e.getMessage());
            }
        }
    }
}

