/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.routing;

import com.google.inject.Inject;
import io.joynr.messaging.IMessagingMulticastSubscriber;
import io.joynr.messaging.IMessagingSkeleton;
import io.joynr.messaging.routing.RoutingTable;
import joynr.ImmutableMessage;
import joynr.Message;
import joynr.system.RoutingTypes.Address;
import joynr.system.RoutingTypes.MqttAddress;
import joynr.system.RoutingTypes.RoutingTypesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGlobalMessagingSkeleton
implements IMessagingSkeleton,
IMessagingMulticastSubscriber {
    private static final Logger logger = LoggerFactory.getLogger(AbstractGlobalMessagingSkeleton.class);
    private final RoutingTable routingTable;

    @Inject
    protected AbstractGlobalMessagingSkeleton(RoutingTable routingTable) {
        this.routingTable = routingTable;
    }

    protected void registerGlobalRoutingEntry(ImmutableMessage message, String gbid) {
        Message.MessageType messageType = message.getType();
        if (!(messageType.equals((Object)Message.MessageType.VALUE_MESSAGE_TYPE_REQUEST) || messageType.equals((Object)Message.MessageType.VALUE_MESSAGE_TYPE_SUBSCRIPTION_REQUEST) || messageType.equals((Object)Message.MessageType.VALUE_MESSAGE_TYPE_BROADCAST_SUBSCRIPTION_REQUEST) || messageType.equals((Object)Message.MessageType.VALUE_MESSAGE_TYPE_MULTICAST_SUBSCRIPTION_REQUEST))) {
            logger.trace("Message type is: {}, no global routing entry added to the routing table for it ", (Object)messageType);
            return;
        }
        String replyTo = message.getReplyTo();
        if (replyTo != null && !replyTo.isEmpty()) {
            Address address = RoutingTypesUtil.fromAddressString((String)replyTo);
            if (address instanceof MqttAddress) {
                MqttAddress mqttAddress = new MqttAddress((MqttAddress)address);
                mqttAddress.setBrokerUri(gbid);
                logger.trace("Register Global Routing Entry of incoming request message {} for MqttAddress with topic: {} for gbid: {}", new Object[]{message.getId(), mqttAddress.getTopic(), mqttAddress.getBrokerUri()});
                address = mqttAddress;
            }
            boolean isGloballyVisible = true;
            long expiryDateMs = message.getTtlMs();
            this.routingTable.put(message.getSender(), address, true, expiryDateMs);
        }
    }
}

