/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.joynr.exceptions.JoynrIllegalStateException;
import java.util.Arrays;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GbidArrayFactory {
    private static final Logger logger = LoggerFactory.getLogger(GbidArrayFactory.class);
    private String[] gbidArray;

    @Inject
    public GbidArrayFactory(@Named(value="joynr.messaging.gbids") String gbids) {
        this.gbidArray = (String[])Arrays.stream(gbids.split(",")).map(a -> a.trim()).toArray(String[]::new);
        if (this.gbidArray.length == 0) {
            if (gbids.contains(",")) {
                throw new JoynrIllegalStateException("just comma is not allowed in gbids");
            }
            logger.warn("Using empty GBID.");
            this.gbidArray = new String[]{""};
        } else if (this.gbidArray.length != 1 && Arrays.stream(this.gbidArray).anyMatch(gbid -> gbid.isEmpty())) {
            logger.error("GBID must not be empty: {}!", (Object)gbids);
            throw new JoynrIllegalStateException("GBID must not be empty: " + gbids + "!");
        }
        HashSet<String> gbidsSet = new HashSet<String>();
        for (String gbid2 : this.gbidArray) {
            if (gbidsSet.contains(gbid2)) {
                throw new JoynrIllegalStateException("duplicate gbid found");
            }
            gbidsSet.add(gbid2);
        }
    }

    public String[] create() {
        return (String[])this.gbidArray.clone();
    }
}

