/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.arbitration;

import io.joynr.arbitration.ArbitrationStrategy;
import io.joynr.arbitration.ArbitrationStrategyFunction;
import io.joynr.arbitration.DiscoveryScope;
import java.util.HashMap;
import java.util.Map;

public class DiscoveryQos {
    public static final DiscoveryQos NO_FILTER;
    public static final long NO_MAX_AGE = Long.MAX_VALUE;
    public static final long NO_VALUE = -1L;
    private static final ArbitrationStrategy DEFAULT_ARBITRATIONSTRATEGY;
    private static final long DEFAULT_CACHEMAXAGE = 0L;
    private static final DiscoveryScope DEFAULT_DISCOVERYSCOPE;
    private static final boolean DEFAULT_PROVIDERMUSTSUPPORTONCHANGE = false;
    long cacheMaxAgeMs;
    private ArbitrationStrategy arbitrationStrategy;
    private ArbitrationStrategyFunction arbitrationStrategyFunction;
    private HashMap<String, String> customParameters = new HashMap();
    private DiscoveryScope discoveryScope;
    private long discoveryTimeoutMs;
    private boolean providerMustSupportOnChange;
    private long retryIntervalMs;

    public DiscoveryQos() {
        this.setDiscoveryTimeoutMs(-1L);
        this.arbitrationStrategy = DEFAULT_ARBITRATIONSTRATEGY;
        this.cacheMaxAgeMs = 0L;
        this.providerMustSupportOnChange = false;
        this.setRetryIntervalMs(-1L);
        this.discoveryScope = DEFAULT_DISCOVERYSCOPE;
    }

    public DiscoveryQos(long discoveryTimeout, ArbitrationStrategy arbitrationStrategy, long cacheMaxAge) {
        this(discoveryTimeout, arbitrationStrategy, cacheMaxAge, DEFAULT_DISCOVERYSCOPE);
    }

    public DiscoveryQos(long discoveryTimeout, ArbitrationStrategyFunction arbitrationStrategyFunction, long cacheMaxAge) {
        this(discoveryTimeout, arbitrationStrategyFunction, cacheMaxAge, DEFAULT_DISCOVERYSCOPE);
    }

    public DiscoveryQos(long discoveryTimeout, ArbitrationStrategy arbitrationStrategy, long cacheMaxAge, DiscoveryScope discoveryScope) {
        this(discoveryTimeout, -1L, arbitrationStrategy, cacheMaxAge, discoveryScope);
    }

    public DiscoveryQos(long discoveryTimeout, long retryIntervalMs, ArbitrationStrategy arbitrationStrategy, long cacheMaxAge, DiscoveryScope discoveryScope) {
        if (arbitrationStrategy.equals((Object)ArbitrationStrategy.Custom)) {
            throw new IllegalStateException("A Custom strategy can only be set by passing an arbitration strategy function to the DiscoveryQos constructor");
        }
        this.cacheMaxAgeMs = cacheMaxAge;
        this.discoveryScope = discoveryScope;
        this.setDiscoveryTimeoutMs(discoveryTimeout);
        this.setRetryIntervalMs(retryIntervalMs);
        this.arbitrationStrategy = arbitrationStrategy;
        this.providerMustSupportOnChange = false;
    }

    public DiscoveryQos(long discoveryTimeout, ArbitrationStrategyFunction arbitrationStrategyFunction, long cacheMaxAge, DiscoveryScope discoveryScope) {
        this(discoveryTimeout, -1L, arbitrationStrategyFunction, cacheMaxAge, discoveryScope);
    }

    public DiscoveryQos(long discoveryTimeout, long retryIntervalMs, ArbitrationStrategyFunction arbitrationStrategyFunction, long cacheMaxAge, DiscoveryScope discoveryScope) {
        this.arbitrationStrategy = ArbitrationStrategy.Custom;
        this.setDiscoveryTimeoutMs(discoveryTimeout);
        this.arbitrationStrategyFunction = arbitrationStrategyFunction;
        this.cacheMaxAgeMs = cacheMaxAge;
        this.discoveryScope = discoveryScope;
        this.setRetryIntervalMs(-1L);
        this.providerMustSupportOnChange = false;
    }

    public void setArbitrationStrategy(ArbitrationStrategy arbitrationStrategy) {
        if (arbitrationStrategy.equals((Object)ArbitrationStrategy.Custom)) {
            throw new IllegalStateException("A Custom strategy can only be set by passing an arbitration strategy function to the DiscoveryQos constructor");
        }
        this.arbitrationStrategy = arbitrationStrategy;
    }

    public ArbitrationStrategy getArbitrationStrategy() {
        return this.arbitrationStrategy;
    }

    public void setDiscoveryTimeoutMs(long discoveryTimeoutMs) {
        if (discoveryTimeoutMs < 0L && discoveryTimeoutMs != -1L) {
            throw new IllegalArgumentException("Discovery timeout cannot be less than zero");
        }
        this.discoveryTimeoutMs = discoveryTimeoutMs;
    }

    public long getDiscoveryTimeoutMs() {
        return this.discoveryTimeoutMs;
    }

    public void addCustomParameter(String key, String value) {
        this.customParameters.put(key, value);
    }

    public Object getCustomParameter(String key) {
        return this.customParameters.get(key);
    }

    public long getCacheMaxAgeMs() {
        return this.cacheMaxAgeMs;
    }

    public void setCacheMaxAgeMs(long cacheMaxAgeMs) {
        this.cacheMaxAgeMs = cacheMaxAgeMs < 0L ? 0L : cacheMaxAgeMs;
    }

    public boolean isLocalOnly() {
        return this.discoveryScope == DiscoveryScope.LOCAL_ONLY;
    }

    public long getRetryIntervalMs() {
        return this.retryIntervalMs;
    }

    public void setRetryIntervalMs(long retryIntervalMs) {
        if (retryIntervalMs < 0L && retryIntervalMs != -1L) {
            throw new IllegalArgumentException("Discovery retry interval cannot be less than zero");
        }
        this.retryIntervalMs = retryIntervalMs;
    }

    public boolean getProviderMustSupportOnChange() {
        return this.providerMustSupportOnChange;
    }

    public void setProviderMustSupportOnChange(boolean providerMustSupportOnChange) {
        this.providerMustSupportOnChange = providerMustSupportOnChange;
    }

    public void setDiscoveryScope(DiscoveryScope discoveryScope) {
        this.discoveryScope = discoveryScope;
    }

    public DiscoveryScope getDiscoveryScope() {
        return this.discoveryScope;
    }

    ArbitrationStrategyFunction getArbitrationStrategyFunction() {
        return this.arbitrationStrategyFunction;
    }

    public Map<String, String> getCustomParameters() {
        return this.customParameters;
    }

    public String toString() {
        return "DiscoveryQos [arbitrationStrategy=" + (Object)((Object)this.arbitrationStrategy) + ", cacheMaxAgeMs=" + this.cacheMaxAgeMs + ", customParameters=" + this.customParameters.toString() + ", discoveryScope=" + (Object)((Object)this.discoveryScope) + ", discoveryTimeoutMs=" + this.discoveryTimeoutMs + ", providerMustSupportOnChange=" + this.providerMustSupportOnChange + ", retryIntervalMs=" + this.retryIntervalMs + "]";
    }

    static {
        DEFAULT_ARBITRATIONSTRATEGY = ArbitrationStrategy.LastSeen;
        DEFAULT_DISCOVERYSCOPE = DiscoveryScope.LOCAL_AND_GLOBAL;
        NO_FILTER = new DiscoveryQos(Long.MAX_VALUE, ArbitrationStrategy.NotSet, Long.MAX_VALUE);
    }
}

