/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.sender;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.joynr.exceptions.JoynrRuntimeException;
import io.joynr.messaging.routing.MessageRouter;
import io.joynr.messaging.sender.MessageSender;
import io.joynr.smrf.EncodingException;
import io.joynr.smrf.UnsuppportedVersionException;
import java.util.ArrayList;
import java.util.List;
import joynr.ImmutableMessage;
import joynr.Message;
import joynr.MutableMessage;

public abstract class AbstractMessageSender
implements MessageSender {
    private MessageRouter messageRouter;
    private String replyToAddress = null;
    private List<MutableMessage> noReplyToAddressQueue = new ArrayList<MutableMessage>();
    private String globalAddress;

    protected AbstractMessageSender(MessageRouter messageRouter) {
        this.messageRouter = messageRouter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="lazy synchronization")
    public void sendMessage(MutableMessage message) {
        boolean needsReplyToAddress = this.needsReplyToAddress(message);
        if (needsReplyToAddress && this.replyToAddress == null) {
            AbstractMessageSender abstractMessageSender = this;
            synchronized (abstractMessageSender) {
                if (this.replyToAddress == null) {
                    this.noReplyToAddressQueue.add(message);
                    return;
                }
            }
        }
        if (needsReplyToAddress) {
            message.setReplyTo(message.isStatelessAsync() ? this.globalAddress : this.replyToAddress);
        }
        this.routeMutableMessage(message);
    }

    private boolean needsReplyToAddress(MutableMessage message) {
        Message.MessageType msgType = message.getType();
        boolean noReplyTo = message.getReplyTo() == null;
        boolean msgTypeNeedsReplyTo = msgType.equals((Object)Message.MessageType.VALUE_MESSAGE_TYPE_REQUEST) || msgType.equals((Object)Message.MessageType.VALUE_MESSAGE_TYPE_SUBSCRIPTION_REQUEST) || msgType.equals((Object)Message.MessageType.VALUE_MESSAGE_TYPE_BROADCAST_SUBSCRIPTION_REQUEST) || msgType.equals((Object)Message.MessageType.VALUE_MESSAGE_TYPE_MULTICAST_SUBSCRIPTION_REQUEST);
        return noReplyTo && msgTypeNeedsReplyTo && !message.isLocalMessage();
    }

    protected synchronized void setReplyToAddress(String replyToAddress, String globalAddress) {
        this.replyToAddress = replyToAddress;
        this.globalAddress = globalAddress;
        for (MutableMessage queuedMessage : this.noReplyToAddressQueue) {
            queuedMessage.setReplyTo(queuedMessage.isStatelessAsync() ? globalAddress : replyToAddress);
            this.routeMutableMessage(queuedMessage);
        }
        this.noReplyToAddressQueue.clear();
    }

    private void routeMutableMessage(MutableMessage mutableMessage) {
        ImmutableMessage immutableMessage;
        try {
            immutableMessage = mutableMessage.getImmutableMessage();
        }
        catch (EncodingException | UnsuppportedVersionException | SecurityException exception) {
            throw new JoynrRuntimeException(exception.getMessage());
        }
        this.messageRouter.route(immutableMessage);
    }
}

